/*
 * Decompiled with CFR 0.152.
 */
package sic.ast.instructions;

import sic.asm.AsmError;
import sic.ast.Program;
import sic.ast.instructions.Instruction;
import sic.ast.instructions.InstructionF34Base;
import sic.ast.storage.StorageData;

public class InstructionLiteral
extends Instruction {
    public final InstructionF34Base command;
    protected StorageData literal;

    public InstructionLiteral(InstructionF34Base instructionF34Base, StorageData storageData) {
        super(instructionF34Base.loc, instructionF34Base.label, instructionF34Base.mnemonic);
        this.command = instructionF34Base;
        this.literal = storageData;
    }

    @Override
    public String toString() {
        return this.command.toString() + " " + this.operandToString();
    }

    @Override
    public void append(Program program) throws AsmError {
        this.enter(program);
        StorageData storageData = program.section().literals.find(this.literal);
        if (storageData != null) {
            this.literal = storageData;
        } else {
            program.section().literals.append(this.literal);
        }
        this.command.setSymbol(this.literal.label);
        program.append(this);
        this.leave(program);
    }

    @Override
    public int size() {
        if (this.command == null) {
            return 3;
        }
        return this.command.size();
    }

    @Override
    public String operandToString() {
        return this.command.symbol + " (" + this.literal.toString() + ")";
    }

    @Override
    public void emitRawCode(byte[] byArray, int n) {
        this.command.emitRawCode(byArray, n);
    }
}

