/*
 * Decompiled with CFR 0.152.
 */
package sic.ast.instructions;

import sic.asm.AsmError;
import sic.asm.Location;
import sic.ast.Program;
import sic.ast.Symbol;
import sic.ast.instructions.Instruction;
import sic.common.Flags;
import sic.common.Mnemonic;

public abstract class InstructionF34Base
extends Instruction {
    protected final Flags flags;
    protected int value;
    protected String symbol;
    protected int resolvedValue;
    protected Symbol resolvedSymbol;

    public InstructionF34Base(Location location, String string, Mnemonic mnemonic, Flags flags, int n, String string2) {
        super(location, string, mnemonic);
        this.flags = flags;
        this.value = n;
        this.symbol = string2;
        if (mnemonic.isExtended()) {
            this.flags.setExtended();
        }
    }

    public boolean operandIsValue() {
        return this.symbol == null;
    }

    @Override
    public String operandToString() {
        Object object;
        Object object2 = object = this.operandIsValue() ? Integer.toString(this.value) : this.symbol;
        if (this.operandIsValue()) {
            if (this.flags.isPCRelative()) {
                object = "(PC)" + (this.value >= 0 ? "+" : "") + (String)object;
            } else if (this.flags.isBaseRelative()) {
                object = "(B)+" + (String)object;
            }
        }
        return this.flags.operandToString((String)object);
    }

    public void setSymbol(String string) {
        this.symbol = string;
    }

    protected abstract void checkSymbol(Program var1, Symbol var2) throws AsmError;

    protected abstract boolean resolveAddressing(Program var1) throws AsmError;

    public void resolve(Program program) throws AsmError {
        if (this.operandIsValue()) {
            this.resolvedValue = this.value;
            this.resolvedSymbol = null;
        } else {
            this.resolvedSymbol = program.section().symbols.get(this.symbol);
            if (this.resolvedSymbol == null) {
                throw new AsmError(this.loc, "Undefined symbol '%s'", this.symbol);
            }
            this.checkSymbol(program, this.resolvedSymbol);
            this.resolvedValue = this.resolvedSymbol.value();
        }
        if (this.resolveAddressing(program)) {
            return;
        }
        throw new AsmError(this.loc, "Cannot address symbol '%s'", this.symbol);
    }

    @Override
    public String explain() {
        String string = "<b>Bits nixbpe:</b> " + this.flags;
        return super.explain() + "<br>" + string;
    }

    @Override
    public Integer resolveOperandAddress(int n) {
        if (this.flags.isPCRelative()) {
            return n + this.size() + this.value;
        }
        if (!this.flags.isImmediate() && this.flags.isAbsolute() && !this.flags.isIndexed()) {
            return this.value;
        }
        return null;
    }
}

