/*
 * Decompiled with CFR 0.152.
 */
package sic.ast.data;

import sic.asm.AsmError;
import sic.asm.parsing.Parser;
import sic.ast.data.Data;
import sic.common.Conversion;

public class DataHex
extends Data {
    public DataHex(int n) {
        super(n);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.data.length + 3);
        stringBuilder.append("X'");
        stringBuilder.append(Conversion.bytesToHex(this.data, 0, this.data.length));
        stringBuilder.append('\'');
        stringBuilder.append(super.toString());
        return stringBuilder.toString();
    }

    @Override
    public void parse(Parser parser, boolean bl) throws AsmError {
        parser.advance('X');
        parser.advance('\'');
        String string = parser.readUntil('\'');
        if (string.length() % 2 == 1) {
            throw new AsmError(parser.loc(), "Invalid length of hex encoding '%s'", string);
        }
        this.data = Conversion.hexToBytes(string);
        if (bl) {
            super.parse(parser, true);
        }
    }
}

