/*
 * Decompiled with CFR 0.152.
 */
package sic.ast;

import sic.asm.AsmError;
import sic.asm.Location;
import sic.ast.Node;
import sic.ast.Program;
import sic.ast.expression.Expr;

public class Symbol
extends Node
implements Comparable<Symbol> {
    public final String name;
    public final Location loc;
    private Scope scope;
    private boolean absolute;
    public LabelType labelType;
    private int value;
    public final Expr expr;
    private boolean evaluated;
    private int dependencyCount;

    public Symbol(String string, Location location, int n, boolean bl) {
        this.name = string;
        this.loc = location;
        this.scope = Scope.LOCAL;
        this.value = n;
        this.expr = null;
        this.evaluated = true;
        this.labelType = bl ? LabelType.DATA : LabelType.CODE;
    }

    public Symbol(String string, Location location, Expr expr) {
        this.name = string;
        this.loc = location;
        this.scope = Scope.LOCAL;
        this.expr = expr;
        this.dependencyCount = expr.countSyms();
        this.labelType = LabelType.NOTLABEL;
    }

    public Symbol(String string, Location location) {
        this.name = string;
        this.loc = location;
        this.value = 0;
        this.expr = null;
        this.scope = Scope.IMPORTED;
        this.labelType = LabelType.NOTLABEL;
    }

    @Override
    public int compareTo(Symbol symbol) {
        return this.name.compareTo(symbol.name);
    }

    public String toString() {
        return this.name + "=" + this.valueToString();
    }

    public Scope scope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public boolean isImported() {
        return this.scope == Scope.IMPORTED;
    }

    public boolean isExported() {
        return this.scope == Scope.EXPORTED;
    }

    public void setExported() {
        this.scope = Scope.EXPORTED;
    }

    public String scopeToString() {
        return this.scope.toString().toLowerCase();
    }

    public String kindToString() {
        if (this.absolute) {
            return "absolute";
        }
        return "relative";
    }

    public String labelTypeToString() {
        return this.labelType.toString().toLowerCase();
    }

    public String valueToString() {
        return this.evaluated ? Integer.toString(this.value) : "?";
    }

    public String exprToString() {
        if (this.scope == Scope.IMPORTED) {
            return "";
        }
        return this.expr == null ? "label" : this.expr.toString();
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public void setAbsolute(boolean bl) {
        this.absolute = bl;
    }

    public int value() {
        return this.value;
    }

    public boolean isEvaluated() {
        return this.evaluated;
    }

    public void eval(Program program) throws AsmError {
        if (this.evaluated) {
            return;
        }
        if (this.expr != null) {
            this.value = this.expr.eval(program);
        }
        this.evaluated = true;
    }

    public int dependencyCount() {
        return this.dependencyCount;
    }

    public boolean decDependencyCount() {
        return --this.dependencyCount == 0;
    }

    static enum Scope {
        LOCAL,
        IMPORTED,
        EXPORTED;

    }

    static enum LabelType {
        NOTLABEL,
        CODE,
        DATA;

    }
}

