/*
 * Decompiled with CFR 0.152.
 */
package sic.ast;

import sic.asm.Location;
import sic.ast.Command;
import sic.ast.Symbol;
import sic.ast.storage.StorageData;
import sic.ast.storage.StorageRes;

public class StorageSymbol
extends Symbol {
    private DataType dataType;
    private Integer elementSize;
    private Integer elementCount;

    public StorageSymbol(String string, Location location, int n, Command command) {
        super(string, location, n, true);
        this.bindCommand(command);
    }

    public Integer getElementSize() {
        return this.elementSize;
    }

    public Integer getElementCount() {
        return this.elementCount;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    private boolean bindCommand(Command command) {
        if (!(command instanceof StorageRes) && !(command instanceof StorageData)) {
            return false;
        }
        switch (command.mnemonic.opcode) {
            case 0: 
            case 3: {
                this.dataType = DataType.BYTE;
                this.elementSize = 1;
                break;
            }
            case 1: 
            case 4: {
                this.dataType = DataType.WORD;
                this.elementSize = 3;
                break;
            }
            case 2: 
            case 5: {
                this.dataType = DataType.FLOAT;
                this.elementSize = 6;
            }
        }
        this.elementCount = command.size() / this.elementSize;
        return true;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public static enum DataType {
        BYTE,
        WORD,
        FLOAT;

    }
}

