/*
 * Decompiled with CFR 0.152.
 */
package sic.ast;

import java.util.ArrayList;
import java.util.List;
import sic.asm.AsmError;
import sic.ast.Block;
import sic.ast.Literals;
import sic.ast.Node;
import sic.ast.Program;
import sic.ast.Relocation;
import sic.ast.Symbols;
import sic.common.SICXE;

public class Section
extends Node {
    public final String name;
    public final List<Block> blocks;
    public final Symbols symbols;
    public final Literals literals;
    public final List<Relocation> relocations;
    private int size;
    private Block block;
    private int baseRegister;

    public Section(String string) {
        this.name = string;
        this.blocks = new ArrayList<Block>();
        this.symbols = new Symbols();
        this.literals = new Literals();
        this.relocations = new ArrayList<Relocation>();
        this.reset();
    }

    public String toString() {
        return this.name();
    }

    public boolean isDefault() {
        return "".equals(this.name);
    }

    public String name() {
        return this.isDefault() ? "<default>" : this.name;
    }

    @Override
    public void enter(Program program) throws AsmError {
        program.switchSection(this.name);
        program.section().switchBlock("");
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int size() {
        return this.size;
    }

    public void reset() {
        this.switchBlock("");
        this.disableBaseAddressing();
    }

    public Block block() {
        return this.block;
    }

    public Block findBlock(String string) {
        for (Block block : this.blocks) {
            if (!block.name.equals(string)) continue;
            return block;
        }
        return null;
    }

    public void switchBlock(String string) {
        this.block = this.findBlock(string);
        if (this.block == null) {
            this.block = new Block(string);
            this.blocks.add(this.block);
        }
    }

    public int PCDisplacement(int n) {
        return n - this.block.nextLocctr();
    }

    public boolean isPCRelativeAddressing(int n) {
        return SICXE.isSdisp(this.PCDisplacement(n));
    }

    public void enableBaseAddressing(int n) {
        assert (n >= 0);
        this.baseRegister = n;
    }

    public void disableBaseAddressing() {
        this.baseRegister = -1;
    }

    public int baseDisplacement(int n) {
        return n - this.baseRegister;
    }

    public boolean isBaseAddressing(int n) {
        return this.baseRegister >= 0 && SICXE.isDisp(this.baseDisplacement(n));
    }

    private void addRelocation(Relocation relocation) {
        this.relocations.add(relocation);
    }

    public void addRelocation(int n, int n2) {
        this.addRelocation(new Relocation(n, n2));
    }

    public void addRelocation(int n, int n2, char c, String string) {
        this.addRelocation(new Relocation(n, n2, c, string));
    }
}

