/*
 * Decompiled with CFR 0.152.
 */
package sic.asm.visitors;

import java.io.Writer;
import sic.asm.ErrorCatcher;
import sic.asm.visitors.WriteVisitor;
import sic.ast.Block;
import sic.ast.Program;
import sic.ast.Relocation;
import sic.ast.Section;
import sic.ast.Symbol;
import sic.ast.storage.StorageData;

public class WriteSections
extends WriteVisitor {
    private final int symLen;

    public WriteSections(Program program, ErrorCatcher errorCatcher, Writer writer) {
        super(program, errorCatcher, writer);
        this.symLen = program.maxSymbolLength();
    }

    public void visit(Program program) {
        this.visitSections(program.sections);
    }

    public void visit(Symbol symbol) {
        this.w(String.format("    %-" + this.symLen + "s  %06X  %8d  %-8s  %-8s  %-8s  %s\n", symbol.name, symbol.value(), symbol.value(), symbol.scopeToString(), symbol.kindToString(), symbol.labelTypeToString(), symbol.exprToString()));
    }

    public void visit(Section section) {
        this.w("***** Section " + section.name() + " *****\n");
        this.w(String.format("Stats: size=%d  blocks=%d  symbols=%d  literals=%d  relocations=%d\n", section.size(), section.block().size(), section.symbols.asSortedList().size(), section.literals.size(), section.relocations.size()));
        this.w("Blocks\n");
        this.w("    name        start   size  #ins #dir #sto\n");
        this.visitBlocks(section.blocks);
        this.w("Symbols\n");
        this.w(String.format("    %-" + this.symLen + "s     hex       dec  scope     kind      type      description\n", "name"));
        this.visitSymbols(section.symbols.asSortedList());
        this.w("Literals\n");
        int n = section.literals.maxLabelLength();
        this.w("    %-" + n + "s  definition\n", "label");
        for (StorageData object : section.literals.literals) {
            this.w("    %-" + n + "s  %s\n", object.label(), object.toString());
        }
        this.w("Relocations\n");
        this.w("    address length flag symbol\n");
        for (Relocation relocation : section.relocations) {
            if (relocation.hasSymbol()) {
                this.w("    %05X   %6d  %c    %s\n", relocation.address, relocation.length, Character.valueOf(relocation.flag), relocation.symbol);
                continue;
            }
            this.w("    %05X   %6d\n", relocation.address, relocation.length);
        }
    }

    public void visit(Block block) {
        this.w(String.format("    %-10s  %05X  %05X  %4d %4d %4d\n", block.name(), block.start(), block.size(), block.countInstructions(), block.countDirectives(), block.countStorages()));
    }
}

