/*
 * Decompiled with CFR 0.152.
 */
package sic.asm.visitors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import sic.asm.AsmError;
import sic.asm.ErrorCatcher;
import sic.ast.Block;
import sic.ast.Command;
import sic.ast.Node;
import sic.ast.Program;
import sic.ast.Section;
import sic.ast.Symbol;

public class Visitor {
    public final Program program;
    public final ErrorCatcher errorCatcher;

    public Visitor(Program program, ErrorCatcher errorCatcher) {
        this.program = program;
        this.errorCatcher = errorCatcher;
        this.begin();
    }

    protected void begin() {
        this.program.switchDefault();
        for (Section section : this.program.sections) {
            section.reset();
            for (Block block : section.blocks) {
                block.reset();
            }
        }
    }

    protected Method findVisitMethod(Node node) {
        Method method = null;
        Class<?> clazz = this.getClass();
        Class<?> clazz2 = node.getClass();
        do {
            try {
                method = clazz.getDeclaredMethod("visit", clazz2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        } while ((clazz2 = clazz2.getSuperclass()) != null && method == null);
        return method;
    }

    protected void visit(Node node) throws AsmError {
        Method method = this.findVisitMethod(node);
        if (method == null) {
            return;
        }
        try {
            method.invoke((Object)this, node);
        }
        catch (IllegalAccessException illegalAccessException) {
            if (illegalAccessException.getCause() instanceof AsmError) {
                throw (AsmError)illegalAccessException.getCause();
            }
            illegalAccessException.printStackTrace();
            System.exit(1);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof AsmError) {
                throw (AsmError)invocationTargetException.getCause();
            }
            invocationTargetException.printStackTrace();
            System.exit(1);
        }
    }

    protected void visitNode(Node node) {
        try {
            node.enter(this.program);
            this.visit(node);
            node.leave(this.program);
        }
        catch (AsmError asmError) {
            this.errorCatcher.add(asmError);
        }
    }

    protected void visitCommands(List<Command> list) {
        for (Command command : list) {
            this.visitNode(command);
        }
    }

    protected void visitBlocks(List<Block> list) {
        for (Block block : list) {
            this.visitNode(block);
        }
    }

    protected void visitSections(List<Section> list) {
        for (Section section : list) {
            this.visitNode(section);
        }
    }

    protected void visitSymbols(List<Symbol> list) {
        for (Symbol symbol : list) {
            this.visitNode(symbol);
        }
    }

    public void visitCommands() {
        this.visitCommands(this.program.commands);
    }

    public void visitByStructure() {
        try {
            this.program.enter(this.program);
            this.visit(this.program);
            this.program.leave(this.program);
        }
        catch (AsmError asmError) {
            this.errorCatcher.add(asmError);
        }
    }
}

