/*
 * Decompiled with CFR 0.152.
 */
package sic;

import java.util.Timer;
import java.util.TimerTask;
import sic.common.Logger;
import sic.loader.Loader;
import sic.sim.Args;
import sic.sim.Executor;
import sic.sim.addons.GraphicalScreen;
import sic.sim.addons.TextualScreen;
import sic.sim.vm.Machine;

public class VM {
    public static final int Version_Major = 2;
    public static final int Version_Minor = 0;
    public static final int Version_Patch = 1;

    static void printHelp() {
        System.out.print("Sic/XE Virtual Machine 2.0.1\nUsage: java sic.VM options parameters\nOptions:\n");
        Args.printArgs();
    }

    public static void main(String[] stringArray) throws Exception {
        GraphicalScreen graphicalScreen;
        Object object;
        Args args = new Args(stringArray);
        if (args.isHelp()) {
            VM.printHelp();
            System.exit(0);
        }
        Machine machine = new Machine();
        Executor executor = new Executor(machine, args);
        if (args.hasFilename()) {
            object = args.getFileext();
            if ("asm".equals(object)) {
                Loader.loadAsm(machine, args.getFilename());
            } else if ("obj".equals(object)) {
                Loader.loadObj(machine, args.getFilename());
            } else {
                Logger.fmterr("Invalid filename extension '%s'", object);
            }
        }
        object = args.isTextScr() ? new TextualScreen(executor) : null;
        GraphicalScreen graphicalScreen2 = graphicalScreen = args.isGraphScr() ? new GraphicalScreen(executor) : null;
        if (args.isGraphScr() || args.isTextScr()) {
            if (object != null) {
                ((TextualScreen)object).setSize(args.getTextScrCols(), args.getTextScrRows());
                ((TextualScreen)object).toggleView();
            }
            if (graphicalScreen != null) {
                graphicalScreen.setSize(args.getGraphScrCols(), args.getGraphScrRows());
                graphicalScreen.toggleView();
            }
            Timer timer = new Timer();
            TimerTask timerTask = new TimerTask((TextualScreen)object){
                final /* synthetic */ TextualScreen val$textScreen;
                {
                    this.val$textScreen = textualScreen;
                }

                @Override
                public void run() {
                    if (this.val$textScreen != null) {
                        this.val$textScreen.updateView();
                    }
                }
            };
            timer.schedule(timerTask, 0L, 50L);
        }
        executor.start();
        while (executor.isRunning()) {
            Thread.sleep(500L);
        }
        System.exit(0);
    }
}

