/*
 * Decompiled with CFR 0.152.
 */
package sic.sim.vm;

import java.util.Stack;
import sic.common.Flags;
import sic.common.Logger;
import sic.common.SICXE;
import sic.sim.breakpoints.DataBreakpointException;
import sic.sim.breakpoints.ReadDataBreakpointException;
import sic.sim.breakpoints.WriteDataBreakpointException;
import sic.sim.vm.Devices;
import sic.sim.vm.Memory;
import sic.sim.vm.MemorySpan;
import sic.sim.vm.Registers;

public class Machine {
    public static final int MAX_ADDRESS = 1048575;
    public static final int MAX_DEVICE = 255;
    public final Registers registers;
    public final Memory memory;
    public final Devices devices;
    private int instructionCount;
    private MemorySpan lastExecAddr;
    private MemorySpan lastExecRead;
    private MemorySpan lastExecWrite;
    private Stack<Integer> addressBelowJSUB = new Stack();
    private boolean indirectX = false;

    public Machine() {
        this.registers = new Registers();
        this.memory = new Memory(0x100000);
        this.devices = new Devices(256);
        this.lastExecRead = new MemorySpan();
        this.lastExecWrite = new MemorySpan();
        this.lastExecAddr = new MemorySpan();
    }

    public int getInstructionCount() {
        return this.instructionCount;
    }

    public MemorySpan getLastExecAddr() {
        return this.lastExecAddr;
    }

    public MemorySpan getLastExecRead() {
        return this.lastExecRead;
    }

    private void setLastExecRead(int n, int n2) {
        this.lastExecWrite.clear();
        this.lastExecRead.set(n, n2);
    }

    public MemorySpan getLastExecWrite() {
        return this.lastExecWrite;
    }

    private void setLastExecWrite(int n, int n2) {
        this.lastExecRead.clear();
        this.lastExecWrite.set(n, n2);
    }

    public void clearLastExecReadWrite() {
        this.lastExecWrite.clear();
        this.lastExecRead.clear();
        this.lastExecAddr.clear();
    }

    private void notImplemented(String string) {
        Logger.fmterr("Instruction '%s' not implemented!", string);
    }

    private void invalidOpcode(int n) {
        Logger.fmterr("Invalid opcode '%d'.", n);
    }

    private void invalidAddressing() {
        Logger.err("Invalid addressing.");
    }

    private boolean execF1(int n) {
        switch (n) {
            case 192: {
                this.registers.setF(this.registers.getAs());
                break;
            }
            case 196: {
                this.registers.setA((int)this.registers.getF());
                break;
            }
            case 200: {
                this.notImplemented("NORM");
                break;
            }
            case 240: {
                this.notImplemented("SIO");
                break;
            }
            case 244: {
                this.notImplemented("HIO");
                break;
            }
            case 248: {
                this.notImplemented("TIO");
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private boolean execF2(int n, int n2) {
        int n3 = (n2 & 0xF0) >> 4;
        int n4 = n2 & 0xF;
        switch (n) {
            case 144: {
                this.registers.set(n4, this.registers.get(n4) + this.registers.get(n3));
                break;
            }
            case 148: {
                this.registers.set(n4, this.registers.get(n4) - this.registers.get(n3));
                break;
            }
            case 152: {
                this.registers.set(n4, this.registers.get(n4) * this.registers.get(n3));
                break;
            }
            case 156: {
                int n5 = this.registers.get(n3);
                if (n5 == 0) {
                    System.out.println("division by zero");
                    break;
                }
                this.registers.set(n4, this.registers.gets(n4) / n5);
                break;
            }
            case 160: {
                this.registers.setSWAfterCompare(this.registers.gets(n3) - this.registers.gets(n4));
                break;
            }
            case 164: {
                this.registers.set(n3, this.registers.get(n3) << n4 + 1 | this.registers.get(n3) >> 24 - n4 - 1);
                break;
            }
            case 168: {
                this.registers.set(n3, this.registers.gets(n3) >> n4 + 1);
                break;
            }
            case 172: {
                this.registers.set(n4, this.registers.get(n3));
                break;
            }
            case 180: {
                this.registers.set(n3, 0);
                break;
            }
            case 184: {
                this.registers.setX(this.registers.getX() + 1);
                this.registers.setSWAfterCompare(this.registers.getXs() - this.registers.gets(n3));
                break;
            }
            case 176: {
                this.notImplemented("SVC");
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private int loadWord(Flags flags, int n) throws ReadDataBreakpointException {
        if (flags.isImmediate()) {
            return n;
        }
        int n2 = this.resolveAddr(flags, n);
        this.setLastExecRead(n2, 3);
        return this.memory.getWord(n2);
    }

    private int loadByte(Flags flags, int n) throws ReadDataBreakpointException {
        if (flags.isImmediate()) {
            return n;
        }
        int n2 = this.resolveAddr(flags, n);
        this.setLastExecRead(n2, 1);
        return this.memory.getByte(n2);
    }

    private double loadFloat(Flags flags, int n) throws ReadDataBreakpointException {
        if (flags.isImmediate()) {
            return n;
        }
        int n2 = this.resolveAddr(flags, n);
        this.setLastExecRead(n2, 6);
        return this.memory.getFloat(n2);
    }

    private int resolveAddr(Flags flags, int n) {
        if (flags.isIndirect()) {
            n = this.memory.getWordRaw(n);
            if (this.indirectX) {
                n += this.registers.getXs();
            }
        }
        return n;
    }

    private void storeWord(Flags flags, int n, int n2) throws WriteDataBreakpointException {
        int n3 = this.resolveAddr(flags, n);
        this.setLastExecWrite(n3, 3);
        this.memory.setWord(n3, n2);
    }

    private void storeByte(Flags flags, int n, int n2) throws WriteDataBreakpointException {
        int n3 = this.resolveAddr(flags, n);
        this.setLastExecWrite(n3, 1);
        this.memory.setByte(n3, n2);
    }

    private void storeFloat(Flags flags, int n, double d) throws WriteDataBreakpointException {
        int n2 = this.resolveAddr(flags, n);
        this.setLastExecWrite(n2, 6);
        this.memory.setFloat(n2, d);
    }

    private boolean execSICF3F4(int n, Flags flags, int n2) throws DataBreakpointException {
        switch (n) {
            case 12: {
                this.storeWord(flags, n2, this.registers.getA());
                break;
            }
            case 16: {
                this.storeWord(flags, n2, this.registers.getX());
                break;
            }
            case 20: {
                this.storeWord(flags, n2, this.registers.getL());
                break;
            }
            case 84: {
                this.storeByte(flags, n2, this.registers.getA());
                break;
            }
            case 120: {
                this.storeWord(flags, n2, this.registers.getB());
                break;
            }
            case 124: {
                this.storeWord(flags, n2, this.registers.getS());
                break;
            }
            case 128: {
                this.storeFloat(flags, n2, this.registers.getF());
                break;
            }
            case 132: {
                this.storeWord(flags, n2, this.registers.getT());
                break;
            }
            case 232: {
                this.storeWord(flags, n2, this.registers.getSW());
                break;
            }
            case 48: {
                if (!this.registers.isEqual()) break;
                this.registers.setPC(this.resolveAddr(flags, n2));
                break;
            }
            case 52: {
                if (!this.registers.isGreater()) break;
                this.registers.setPC(this.resolveAddr(flags, n2));
                break;
            }
            case 56: {
                if (!this.registers.isLower()) break;
                this.registers.setPC(this.resolveAddr(flags, n2));
                break;
            }
            case 60: {
                this.registers.setPC(this.resolveAddr(flags, n2));
                break;
            }
            case 76: {
                this.registers.setPC(this.registers.getL());
                this.popJSUB();
                break;
            }
            case 72: {
                this.registers.setL(this.registers.getPC());
                this.pushJSUB();
                this.registers.setPC(this.resolveAddr(flags, n2));
                break;
            }
            case 0: {
                this.registers.setA(this.loadWord(flags, n2));
                break;
            }
            case 4: {
                this.registers.setX(this.loadWord(flags, n2));
                break;
            }
            case 8: {
                this.registers.setL(this.loadWord(flags, n2));
                break;
            }
            case 80: {
                this.registers.setALo(this.loadByte(flags, n2));
                break;
            }
            case 104: {
                this.registers.setB(this.loadWord(flags, n2));
                break;
            }
            case 108: {
                this.registers.setS(this.loadWord(flags, n2));
                break;
            }
            case 112: {
                this.registers.setF(this.loadFloat(flags, n2));
                break;
            }
            case 116: {
                this.registers.setT(this.loadWord(flags, n2));
                break;
            }
            case 24: {
                this.registers.setA(this.registers.getA() + this.loadWord(flags, n2));
                break;
            }
            case 28: {
                this.registers.setA(this.registers.getA() - this.loadWord(flags, n2));
                break;
            }
            case 32: {
                this.registers.setA(this.registers.getA() * this.loadWord(flags, n2));
                break;
            }
            case 36: {
                int n3 = SICXE.swordToInt(this.loadWord(flags, n2));
                if (n3 == 0) {
                    System.out.println("division by zero");
                    break;
                }
                this.registers.setA(this.registers.getAs() / n3);
                break;
            }
            case 64: {
                this.registers.setA(this.registers.getA() & this.loadWord(flags, n2));
                break;
            }
            case 68: {
                this.registers.setA(this.registers.getA() | this.loadWord(flags, n2));
                break;
            }
            case 40: {
                this.registers.setSWAfterCompare(this.registers.getAs() - SICXE.swordToInt(this.loadWord(flags, n2)));
                break;
            }
            case 44: {
                this.registers.setX(this.registers.getX() + 1);
                this.registers.setSWAfterCompare(this.registers.getXs() - SICXE.swordToInt(this.loadWord(flags, n2)));
                break;
            }
            case 216: {
                this.registers.setALo(this.devices.read(this.loadByte(flags, n2)));
                break;
            }
            case 220: {
                this.devices.write(this.loadByte(flags, n2), this.registers.getALo());
                break;
            }
            case 224: {
                this.registers.setSWAfterCompare(this.devices.test(this.loadByte(flags, n2)) ? -1 : 0);
                break;
            }
            case 88: {
                this.registers.setF(this.registers.getF() + this.loadFloat(flags, n2));
                break;
            }
            case 92: {
                this.registers.setF(this.registers.getF() - this.loadFloat(flags, n2));
                break;
            }
            case 96: {
                this.registers.setF(this.registers.getF() * this.loadFloat(flags, n2));
                break;
            }
            case 100: {
                this.registers.setF(this.registers.getF() / this.loadFloat(flags, n2));
                break;
            }
            case 136: {
                double d = this.registers.getF() - this.loadFloat(flags, n2);
                this.registers.setSWAfterCompare(d > 0.0 ? 1 : (d < 0.0 ? -1 : 0));
                break;
            }
            case 208: {
                this.notImplemented("LPS");
                break;
            }
            case 212: {
                this.notImplemented("STI");
                break;
            }
            case 236: {
                this.notImplemented("SSK");
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public int fetch() {
        int n = this.memory.getByteRaw(this.registers.getPC());
        this.registers.incPC();
        return n;
    }

    public void execute() throws DataBreakpointException {
        int n;
        this.indirectX = false;
        ++this.instructionCount;
        this.lastExecRead.clear();
        this.lastExecWrite.clear();
        this.lastExecAddr.setStartAddress(this.registers.getPC());
        this.lastExecAddr.setSpanLength(0);
        int n2 = this.fetch();
        if (this.execF1(n2)) {
            this.lastExecAddr.setSpanLength(1);
            return;
        }
        int n3 = this.fetch();
        if (this.execF2(n2, n3)) {
            this.lastExecAddr.setSpanLength(2);
            return;
        }
        Flags flags = new Flags(n2, n3);
        int n4 = 0;
        if (flags.isSic()) {
            n = flags.operandSic(n3, this.fetch());
            n4 = 3;
        } else if (flags.isExtended()) {
            n = flags.operandF4(n3, this.fetch(), this.fetch());
            if (flags.isRelative()) {
                this.invalidAddressing();
            }
            n4 = 4;
        } else {
            n4 = 3;
            n = flags.operandF3(n3, this.fetch());
            if (flags.isPCRelative()) {
                n = flags.operandPCRelative(n) + this.registers.getPC();
            } else if (flags.isBaseRelative()) {
                n += this.registers.getB();
            } else if (!flags.isAbsolute()) {
                this.invalidAddressing();
            }
        }
        if (flags.isIndexed()) {
            if (flags.isSimple()) {
                n += this.registers.getXs();
            } else if (flags.isIndirect()) {
                this.indirectX = true;
            } else {
                this.invalidAddressing();
            }
        }
        if (this.execSICF3F4(n2 & 0xFC, flags, n)) {
            this.lastExecAddr.setSpanLength(n4);
            return;
        }
        this.invalidOpcode(n2);
    }

    private void pushJSUB() {
        this.addressBelowJSUB.push(this.registers.getPC());
    }

    private void popJSUB() {
        this.addressBelowJSUB.pop();
    }

    public Integer getAddressBelowLastJSUB() {
        if (this.addressBelowJSUB.isEmpty()) {
            return null;
        }
        return this.addressBelowJSUB.peek();
    }
}

