/*
 * Decompiled with CFR 0.152.
 */
package sic.link.visitors;

import java.util.Map;
import sic.link.LinkerError;
import sic.link.Options;
import sic.link.section.ExtDef;
import sic.link.section.MRecord;
import sic.link.section.Section;
import sic.link.section.TRecord;
import sic.link.visitors.SectionVisitor;

public class SecondPassVisitor
extends SectionVisitor {
    private static final String PHASE = "second pass";
    private Map<String, ExtDef> esTable;
    private Section currSection = null;
    private Options options;
    private String progname;

    public SecondPassVisitor(String string, Map<String, ExtDef> map, Options options) {
        this.progname = string;
        this.esTable = map;
        this.options = options;
    }

    @Override
    public void visit(Section section) throws LinkerError {
        this.currSection = section;
        if (section.getMRecords() != null) {
            for (MRecord mRecord : section.getMRecords()) {
                mRecord.accept(this);
            }
        }
    }

    @Override
    public void visit(MRecord mRecord) throws LinkerError {
        if (mRecord.getSymbol() != null && !mRecord.getSymbol().equals(this.progname)) {
            ExtDef extDef = this.esTable.get(mRecord.getSymbol());
            if (extDef == null) {
                if (this.options.isForce()) {
                    if (this.options.isVerbose()) {
                        System.out.println(mRecord.getSymbol() + " is not defined in any section, allowing because -force option is set");
                    }
                    return;
                }
                throw new LinkerError(PHASE, mRecord.getSymbol() + " is not defined in any section ", mRecord.getLocation());
            }
            long l = mRecord.getStart() + this.currSection.getStart();
            long l2 = l + (long)(mRecord.getLength() / 2);
            TRecord tRecord = null;
            TRecord tRecord2 = null;
            int n = 0;
            if (this.currSection.getTRecords() != null) {
                for (TRecord tRecord3 : this.currSection.getTRecords()) {
                    if (tRecord3.contains(l)) {
                        tRecord = tRecord3;
                        if (tRecord3.contains(l2) || ++n == 2) break;
                    }
                    if (!tRecord3.contains(l2)) continue;
                    tRecord2 = tRecord3;
                    if (++n != 2) continue;
                    break;
                }
            }
            if (tRecord == null) {
                throw new LinkerError(PHASE, "Address " + l + " is not present in any T Record", mRecord.getLocation());
            }
            int n2 = (int)(l - tRecord.getStartAddr()) * 2;
            n2 = n2 + 6 - mRecord.getLength();
            int n3 = n2 + mRecord.getLength();
            Object object = tRecord.getText();
            int n4 = ((String)object).length();
            if (tRecord2 != null && tRecord != tRecord2) {
                object = (String)object + tRecord2.getText();
            }
            String string = ((String)object).substring(n2, n3);
            long l3 = (long)Integer.decode("0x" + string).intValue() + extDef.getCsAddress();
            l3 = mRecord.isPositive() ? (l3 += extDef.getAddress()) : (l3 -= extDef.getAddress());
            String string2 = String.format("%0" + mRecord.getLength() + "X", l3);
            object = ((String)object).substring(0, n2) + string2 + ((String)object).substring(n3);
            tRecord.setText(((String)object).substring(0, n4));
            if (tRecord2 != null && tRecord != tRecord2) {
                object = ((String)object).substring(n4);
                tRecord2.setText((String)object);
            }
            if (this.options.isVerbose()) {
                System.out.println("fixing " + mRecord.getLength() + " half-bytes from " + string + " to " + string2 + "   symbol=" + extDef.getName());
            }
            mRecord.setSymbol(this.progname);
            mRecord.setStart(mRecord.getStart() + this.currSection.getStart());
        }
    }
}

