/*
 * Decompiled with CFR 0.152.
 */
package sic.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sic.common.Format;
import sic.common.Mnemonic;

public class Mnemonics {
    public final Map<String, Mnemonic> map = new HashMap<String, Mnemonic>();

    public Mnemonics() {
        this.initMnemonics();
    }

    public Mnemonic get(String string) {
        if (this.map.containsKey(string)) {
            return this.map.get(string);
        }
        return null;
    }

    public void put(Mnemonic mnemonic) {
        this.map.put(mnemonic.name, mnemonic);
    }

    public void put(String string, int n, Format format, String string2, String string3) {
        this.put(new Mnemonic(string, n, format, string2, string3));
    }

    public void put(String string, Format format, String string2, String string3) {
        this.put(new Mnemonic(string, 0, format, string2, string3));
    }

    public void put34(String string, int n, String string2, String string3) {
        this.put(new Mnemonic(string, n, Format.F3m, string2, string3));
        this.put(new Mnemonic("+" + string, n, Format.F4m, string2, string3));
    }

    public List<Mnemonic> sortByKindName() {
        ArrayList<Mnemonic> arrayList = new ArrayList<Mnemonic>(this.map.values());
        Collections.sort(arrayList, new Comparator<Mnemonic>(){

            @Override
            public int compare(Mnemonic mnemonic, Mnemonic mnemonic2) {
                String string;
                String string2 = mnemonic.getClass().getName();
                int n = string2.compareTo(string = mnemonic2.getClass().getName());
                if (n != 0) {
                    return n;
                }
                return mnemonic.name.compareTo(mnemonic2.name);
            }
        });
        return arrayList;
    }

    public List<Mnemonic> sortByName() {
        ArrayList<Mnemonic> arrayList = new ArrayList<Mnemonic>(this.map.values());
        Collections.sort(arrayList, new Comparator<Mnemonic>(){

            @Override
            public int compare(Mnemonic mnemonic, Mnemonic mnemonic2) {
                return mnemonic.name.compareTo(mnemonic2.name);
            }
        });
        return arrayList;
    }

    public List<String> getReferenceShort() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Mnemonic mnemonic : this.sortByKindName()) {
            if (mnemonic.isExtended()) continue;
            arrayList.add(String.format("%-6s  %-10s", mnemonic.name, mnemonic.format.hint()));
        }
        return arrayList;
    }

    public void printReferenceShort() {
        List<String> list = this.getReferenceShort();
        int n = list.size() / 2;
        int n2 = list.size() % 2;
        for (int i = 0; i < n; ++i) {
            String string = list.get(i);
            String string2 = list.get(n + n2 + i);
            System.out.println(string + "\t" + string2);
        }
        if (n2 > 0) {
            System.out.println(list.get(n));
        }
    }

    public void printReferenceLong() {
        for (Mnemonic mnemonic : this.sortByKindName()) {
            if (mnemonic.isExtended()) continue;
            System.out.println(String.format("%-6s  %-10s  %-16s  %s", mnemonic.name, mnemonic.format.hint(), mnemonic.hint, mnemonic.desc));
        }
    }

    public void initMnemonics() {
        this.put("START", 0, Format.De, "directive", "Define program name and start address.");
        this.put("END", 1, Format.De, "directive", "End of program.");
        this.put("CSECT", 2, Format.D, "directive", "Declare section.");
        this.put("USE", 3, Format.Ds0, "directive", "Block entry.");
        this.put("EXTREF", 4, Format.Ds_, "directive", "Import symbols");
        this.put("EXTDEF", 5, Format.Ds_, "directive", "Export symbols");
        this.put("ORG", 6, Format.De0, "directive", "Set location counter.");
        this.put("LTORG", 7, Format.D, "directive", "Flush literals.");
        this.put("BASE", 8, Format.De, "directive", "Set base register.");
        this.put("NOBASE", 9, Format.D, "directive", "Unset base register.");
        this.put("EQU", 10, Format.De, "directive", "Equate symbol to expression.");
        this.put("RESB", 0, Format.Se, "storage", "Reserve n bytes.");
        this.put("RESW", 1, Format.Se, "storage", "Reserve n words.");
        this.put("RESF", 2, Format.Se, "storage", "Reserve n floats.");
        this.put("BYTE", 3, Format.Sd, "storage", "Initialize bytes.");
        this.put("WORD", 4, Format.Sd, "storage", "Initialize words.");
        this.put("FLOT", 5, Format.Sd, "storage", "Initialize floats.");
        this.put("FIX", 196, Format.F1, "A<-int(F)", "Convert to fixed point number.");
        this.put("FLOAT", 192, Format.F1, "F<-float(A)", "Convert to floating point number.");
        this.put("NORM", 200, Format.F1, "F<-norm(F)", "Normalize.");
        this.put("SIO", 240, Format.F1, "Start S, A", "Start program S of I/O channel A.");
        this.put("HIO", 244, Format.F1, "Halt A", "Halt IO channel (A).");
        this.put("TIO", 248, Format.F1, "Test A", "Test IO channel (A).");
        this.put("SVC", 176, Format.F2n, "Interrupt n", "Generate SVC interrupt n.");
        this.put("CLEAR", 180, Format.F2r, "r<-0", "Clear register.");
        this.put("TIXR", 184, Format.F2r, "X<-(X)+1;(X):(r)", "Increment and compare index register.");
        this.put("SHIFTL", 164, Format.F2rn, "(r)<-(r)<<n", "Shift left n bits");
        this.put("SHIFTR", 168, Format.F2rn, "(r)<-(r)>>n", "Shift right n bits");
        this.put("ADDR", 144, Format.F2rr, "r2<-(r2)+(r1)", "Add registers");
        this.put("SUBR", 148, Format.F2rr, "r2<-(r2)-(r1)", "Subtract registers");
        this.put("MULR", 152, Format.F2rr, "r2<-(r2)*(r1)", "Multiply registers");
        this.put("DIVR", 156, Format.F2rr, "r2<-(r2)/(r1)", "Divide registers");
        this.put("COMPR", 160, Format.F2rr, "(r1):(r2)", "Compare registers");
        this.put("RMO", 172, Format.F2rr, "(r2)<-(r1)", "Move register");
        this.put34("LDA", 0, "A<-(m..m+2)", "Load register A from address m");
        this.put34("LDCH", 80, "A.1<-(m)", "Load byte to register A from address m");
        this.put34("LDB", 104, "B<-(m..m+2)", "Load register B from address m");
        this.put34("LDF", 112, "F<-(m..m+5)", "Load register F from address m");
        this.put34("LDL", 8, "L<-(m..m+2)", "Load register L from address m");
        this.put34("LDS", 108, "S<-(m..m+2)", "Load register S from address m");
        this.put34("LDT", 116, "T<-(m..m+2)", "Load register T from address m");
        this.put34("LDX", 4, "X<-(m..m+2)", "Load register X from address m");
        this.put34("LPS", 208, "PS->(m..2)", "Load processor status from address m");
        this.put34("STA", 12, "m..m+2<-(A)", "Store register A to address m");
        this.put34("STCH", 84, "m<-(A.1)", "Store byte from register A to address m");
        this.put34("STB", 120, "m..m+2<-(B)", "Store register B to address m");
        this.put34("STF", 128, "m..m+5<-(F)", "Store register F to address m");
        this.put34("STL", 20, "m..m+2<-(L)", "Store register L to address m");
        this.put34("STS", 124, "m..m+2<-(S)", "Store register S to address m");
        this.put34("STT", 132, "m..m+2<-(T)", "Store register T to address m");
        this.put34("STX", 16, "m..m+2<-(X)", "Store register X to address m");
        this.put34("STI", 212, "timer<-(m..m+2)", "Set interval timer");
        this.put34("STSW", 232, "m..m+2<-(SW)", "Store processor status word to address m");
        this.put34("ADD", 24, "A<-(A)+(m..m+2)", "Add to accumulator");
        this.put34("SUB", 28, "A<-(A)-(m..m+2)", "Subtract from accumulator");
        this.put34("MUL", 32, "A<-(A)*(m..m+2)", "Multiply with accumultator");
        this.put34("DIV", 36, "A<-(A)/(m..m+2)", "Divide accumulator");
        this.put34("COMP", 40, "A<-(A):(m..m+2)", "Compare accumulator");
        this.put34("AND", 64, "A<-(A)&(m..m+2)", "Bitwise and accumulator");
        this.put34("OR", 68, "A<-(A)|(m..m+2)", "Bitwise or accumulator");
        this.put34("TIX", 44, "X<-(X)+1;(X):(m..m+2)", "Increment and compare index register");
        this.put34("ADDF", 88, "F<-(F)+(m..m+2)", "Floating point addition");
        this.put34("SUBF", 92, "F<-(F)-(m..m+2)", "Floating point subtraction");
        this.put34("MULF", 96, "F<-(F)*(m..m+2)", "Floating point multiplication");
        this.put34("DIVF", 100, "F<-(F)/(m..m+2)", "Floating point division");
        this.put34("COMPF", 136, "F<-(F):(m..m+5)", "Floating point comparison");
        this.put34("J", 60, "PC<-m\t", "Unconditional jump");
        this.put34("JEQ", 48, "PC<-m if CC is =", "Jump if equal");
        this.put34("JGT", 52, "PC<-m if CC is >", "Jump if greater than");
        this.put34("JLT", 56, "PC<-m if CC is <", "Jump if lower than");
        this.put34("JSUB", 72, "L<-(PC);PC<-m", "Jump to subrutine");
        this.put("RSUB", 76, Format.F3, "PC<-(L)", "Return from subroutine.");
        this.put34("RD", 216, "A.1<-readdev (m)", "Read from device");
        this.put34("WD", 220, "writedev(m),A.1", "Write to device");
        this.put34("TD", 224, "testdev(m)", "Test device");
        this.put34("SSK", 236, "m<-(A)\t", "Protection key for address");
    }
}

