/*
 * Decompiled with CFR 0.152.
 */
package sic.ast;

import java.util.ArrayList;
import java.util.List;
import sic.asm.AsmError;
import sic.ast.Command;
import sic.ast.Node;
import sic.ast.Program;
import sic.ast.directives.Directive;
import sic.ast.instructions.Instruction;
import sic.ast.storage.Storage;

public class Block
extends Node {
    public final String name;
    public final List<Command> commands;
    private int countInstruction;
    private int countDirective;
    private int countStorage;
    private int start;
    private int locctr;
    private int nextLocctr;
    private int lastLocctr;
    private int size;

    public Block(String string) {
        this.name = string;
        this.commands = new ArrayList<Command>();
    }

    public String toString() {
        return this.name();
    }

    public boolean isDefault() {
        return "".equals(this.name);
    }

    public String name() {
        return this.isDefault() ? "<default>" : this.name;
    }

    public void append(Command command) {
        this.commands.add(command);
        if (command instanceof Instruction) {
            ++this.countInstruction;
        }
        if (command instanceof Directive) {
            ++this.countDirective;
        }
        if (command instanceof Storage) {
            ++this.countStorage;
        }
    }

    public int countInstructions() {
        return this.countInstruction;
    }

    public int countDirectives() {
        return this.countDirective;
    }

    public int countStorages() {
        return this.countStorage;
    }

    public void reset() {
        this.setLocctr(this.start);
        this.lastLocctr = -1;
    }

    public int start() {
        return this.start;
    }

    public void setStart(int n) {
        this.start = n;
        this.setLocctr(n);
    }

    public int locctr() {
        return this.locctr;
    }

    public void setLocctr(int n) {
        this.locctr = this.nextLocctr = n;
    }

    public int nextLocctr() {
        return this.nextLocctr;
    }

    public void step(int n) {
        this.locctr = this.nextLocctr;
        this.nextLocctr += n;
    }

    public void setOrigin(int n) {
        if (this.lastLocctr < 0) {
            this.lastLocctr = this.nextLocctr;
        }
        this.setLocctr(n);
    }

    public void restoreLocctr() {
        if (this.lastLocctr >= 0) {
            this.setLocctr(this.lastLocctr);
            this.lastLocctr = -1;
        }
    }

    public int size() {
        return this.size;
    }

    @Override
    public void enter(Program program) throws AsmError {
        program.section().switchBlock(this.name);
    }

    @Override
    public void leave(Program program) throws AsmError {
        this.size = this.nextLocctr - this.start;
    }
}

