/*
 * Decompiled with CFR 0.152.
 */
package sic.sim.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseWheelEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import sic.common.Conversion;
import sic.common.SICXE;
import sic.sim.Executor;
import sic.sim.views.HexEdit;

public class MemoryView {
    private JButton btnUpUpUp;
    private JButton btnUpUp;
    private JButton btnUp;
    private JButton btnDn;
    private JButton btnDnDn;
    private JButton btnDnDnDn;
    private HexEdit hex;
    private JTextField txtLocation;
    private JTextField txtCursor;
    public JPanel mainPanel;

    public MemoryView(Executor executor) {
        this.$$$setupUI$$$();
        this.hex.setMachine(executor.getMachine());
        this.btnUpUpUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryView.this.hex.moveStartAddress(-4096);
                MemoryView.this.hex.requestFocus();
                MemoryView.this.updateView();
            }
        });
        this.btnUpUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryView.this.hex.moveStartAddress(-256);
                MemoryView.this.hex.requestFocus();
                MemoryView.this.updateView();
            }
        });
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryView.this.hex.moveStartAddress(-16);
                MemoryView.this.hex.requestFocus();
                MemoryView.this.updateView();
            }
        });
        this.btnDn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryView.this.hex.moveStartAddress(16);
                MemoryView.this.hex.requestFocus();
                MemoryView.this.updateView();
            }
        });
        this.btnDnDn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryView.this.hex.moveStartAddress(256);
                MemoryView.this.hex.requestFocus();
                MemoryView.this.updateView();
            }
        });
        this.btnDnDnDn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryView.this.hex.moveStartAddress(4096);
                MemoryView.this.hex.requestFocus();
                MemoryView.this.updateView();
            }
        });
        this.txtLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryView.this.hex.setStartAddress(SICXE.intToAddr(Conversion.hexToInt(MemoryView.this.txtLocation.getText())));
                MemoryView.this.hex.requestFocus();
                MemoryView.this.updateView();
            }
        });
        this.hex.onAddressChange = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryView.this.updateView();
            }
        };
        this.hex.addMouseWheelListener(new MouseAdapter(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                MemoryView.this.hex.moveStartAddress(mouseWheelEvent.getWheelRotation());
                MemoryView.this.hex.requestFocus();
                MemoryView.this.updateView();
            }
        });
    }

    public void updateView() {
        this.txtLocation.setText(Conversion.addrToHex(this.hex.getStartAddress()));
        this.txtCursor.setText(Conversion.addrToHex(this.hex.getCursorAddress()));
        this.hex.repaint();
    }

    private void $$$setupUI$$$() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout(0, 0));
        this.mainPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), "Memory", 0, 0, null, null));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.mainPanel.add((Component)jPanel, "South");
        this.btnUpUpUp = new JButton();
        this.btnUpUpUp.setPreferredSize(new Dimension(60, 29));
        this.btnUpUpUp.setText("<<<");
        jPanel.add(this.btnUpUpUp);
        this.btnUpUp = new JButton();
        this.btnUpUp.setPreferredSize(new Dimension(60, 29));
        this.btnUpUp.setText("<<");
        jPanel.add(this.btnUpUp);
        this.btnUp = new JButton();
        this.btnUp.setPreferredSize(new Dimension(60, 29));
        this.btnUp.setText("<");
        jPanel.add(this.btnUp);
        this.txtLocation = new JTextField();
        this.txtLocation.setColumns(4);
        this.txtLocation.setText("00000");
        jPanel.add(this.txtLocation);
        this.txtCursor = new JTextField();
        this.txtCursor.setColumns(4);
        this.txtCursor.setText("00000");
        jPanel.add(this.txtCursor);
        this.btnDn = new JButton();
        this.btnDn.setPreferredSize(new Dimension(60, 29));
        this.btnDn.setText(">");
        jPanel.add(this.btnDn);
        this.btnDnDn = new JButton();
        this.btnDnDn.setPreferredSize(new Dimension(60, 29));
        this.btnDnDn.setText(">>");
        jPanel.add(this.btnDnDn);
        this.btnDnDnDn = new JButton();
        this.btnDnDnDn.setPreferredSize(new Dimension(60, 29));
        this.btnDnDnDn.setText(">>>");
        jPanel.add(this.btnDnDnDn);
        this.hex = new HexEdit();
        Font font = this.$$$getFont$$$("Lucida Console", -1, -1, this.hex.getFont());
        if (font != null) {
            this.hex.setFont(font);
        }
        this.mainPanel.add((Component)this.hex, "Center");
    }

    private Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

