/*
 * Decompiled with CFR 0.152.
 */
package sic.link.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import sic.link.LinkerError;
import sic.link.Options;
import sic.link.section.ExtDef;
import sic.link.section.ExtRef;
import sic.link.section.MRecord;
import sic.link.section.Section;
import sic.link.section.TRecord;

public class Writer {
    private static final String PHASE = "writer";
    private Options options;
    private Section section;

    public Writer(Section section, Options options) {
        this.options = options;
        this.section = section;
    }

    public File write() throws LinkerError {
        PrintWriter printWriter;
        if (this.options.getOutputPath() == null) {
            this.options.setOutputName(this.section.getName() + "_ln.obj");
            this.options.setOutputPath(this.section.getName() + "_ln.obj");
        }
        try {
            printWriter = new PrintWriter(this.options.getOutputPath());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new LinkerError(PHASE, "Unable to write to " + this.options.getOutputPath());
        }
        if (this.options.isVerbose()) {
            System.out.println("writing the result to " + this.options.getOutputPath());
        }
        if (this.section.getName().length() > 6) {
            this.section.setName(this.section.getName().substring(0, 6));
        }
        printWriter.print("H");
        printWriter.printf("%-6s", this.section.getName());
        printWriter.printf("%06X", this.section.getStart());
        printWriter.printf("%06X", this.section.getLength());
        printWriter.print('\n');
        if (this.section.getTRecords() != null) {
            for (TRecord object : this.section.getTRecords()) {
                printWriter.print("T");
                printWriter.printf("%06X", object.getStartAddr());
                printWriter.printf("%02X", object.getLength());
                printWriter.print(object.getText());
                printWriter.print('\n');
            }
        }
        if (this.section.getMRecords() != null) {
            for (MRecord mRecord : this.section.getMRecords()) {
                printWriter.print("M");
                printWriter.printf("%06X", mRecord.getStart());
                printWriter.printf("%02X", mRecord.getLength());
                if (mRecord.getSymbol() != null) {
                    if (mRecord.isPositive()) {
                        printWriter.print("+");
                    } else {
                        printWriter.print("-");
                    }
                    printWriter.print(mRecord.getSymbol());
                }
                printWriter.print('\n');
            }
        }
        if (this.section.getExtDefs() != null && this.section.getExtDefs().size() > 0) {
            printWriter.print("D");
            int n = 0;
            for (ExtDef extDef : this.section.getExtDefs()) {
                printWriter.printf("%-6s", extDef.getName());
                printWriter.printf("%06X", extDef.getCsAddress() + extDef.getAddress());
                printWriter.print(" ");
                if (++n % 6 != 0 || n >= this.section.getExtDefs().size()) continue;
                printWriter.print('\n');
                printWriter.print("D");
            }
            printWriter.print('\n');
        }
        if (this.section.getExtRefs() != null) {
            for (ExtRef extRef : this.section.getExtRefs()) {
                printWriter.print("R");
                printWriter.printf("%-6s", extRef.getName());
                printWriter.print('\n');
            }
        }
        if (this.section.getERecord() != null) {
            printWriter.print("E");
            printWriter.printf("%06X", this.section.getERecord().getStartAddr());
            printWriter.print('\n');
        }
        printWriter.flush();
        printWriter.close();
        return new File(this.options.getOutputPath());
    }

    public Section getSection() {
        return this.section;
    }

    public void setSection(Section section) {
        this.section = section;
    }
}

