/*
 * Decompiled with CFR 0.152.
 */
package sic.ast.instructions;

import sic.asm.AsmError;
import sic.asm.Location;
import sic.ast.Program;
import sic.ast.Symbol;
import sic.ast.instructions.InstructionF34Base;
import sic.common.Flags;
import sic.common.Mnemonic;

public class InstructionF4m
extends InstructionF34Base {
    public InstructionF4m(Location location, String string, Mnemonic mnemonic, Flags flags, int n, String string2) {
        super(location, string, mnemonic, flags, n, string2);
        flags.setExtended();
    }

    @Override
    protected void checkSymbol(Program program, Symbol symbol) throws AsmError {
    }

    @Override
    protected boolean resolveAddressing(Program program) throws AsmError {
        if (this.resolvedSymbol != null) {
            if (this.resolvedSymbol.isImported()) {
                program.section().addRelocation(program.locctr() + 1, 5, '+', this.symbol);
            } else {
                program.section().addRelocation(program.locctr() + 1, 5);
            }
            return this.resolvedValue >= this.flags.minOperand() && this.resolvedValue <= this.flags.maxOperand();
        }
        return true;
    }

    @Override
    public int size() {
        return 4;
    }

    @Override
    public void emitRawCode(byte[] byArray, int n) {
        byArray[n] = this.flags.combineWithOpcode(this.mnemonic.opcode);
        byArray[n + 1] = (byte)(this.flags.get_xbpe() | this.resolvedValue >> 16 & 0xF);
        byArray[n + 2] = (byte)(this.resolvedValue >> 8 & 0xFF);
        byArray[n + 3] = (byte)(this.resolvedValue & 0xFF);
    }
}

