/*
 * Decompiled with CFR 0.152.
 */
package sic.ast;

import java.util.ArrayList;
import java.util.List;
import sic.asm.AsmError;
import sic.ast.Program;
import sic.ast.storage.StorageData;

public class Literals {
    public final List<StorageData> literals = new ArrayList<StorageData>();
    private int lastFlushed;
    private int maxLabelLength = 6;

    public int size() {
        return this.literals.size();
    }

    public int maxLabelLength() {
        return this.maxLabelLength;
    }

    public String makeUniqLabel() {
        return "*" + this.literals.size();
    }

    public void append(StorageData storageData) {
        this.literals.add(storageData);
        if (storageData.label().length() > this.maxLabelLength) {
            this.maxLabelLength = storageData.label().length();
        }
    }

    public StorageData find(StorageData storageData) {
        for (int i = this.lastFlushed; i < this.literals.size(); ++i) {
            StorageData storageData2 = this.literals.get(i);
            if (!storageData.equals(storageData2)) continue;
            return storageData2;
        }
        return null;
    }

    public void flush(Program program) throws AsmError {
        while (this.lastFlushed < this.literals.size()) {
            program.append(this.literals.get(this.lastFlushed++));
        }
    }
}

