/*
 * Decompiled with CFR 0.152.
 */
package sic.asm;

import java.io.Writer;
import sic.asm.ErrorCatcher;
import sic.asm.parsing.Parser;
import sic.asm.visitors.DefineEQUs;
import sic.asm.visitors.EvalEQUs;
import sic.asm.visitors.ResolveAbsolute;
import sic.asm.visitors.ResolveBlocks;
import sic.asm.visitors.ResolveRelative;
import sic.asm.visitors.ResolveSymbols;
import sic.asm.visitors.WriteProgram;
import sic.asm.visitors.WriteSections;
import sic.asm.visitors.WriteText;
import sic.ast.Program;
import sic.common.Mnemonics;

public class Assembler {
    public final ErrorCatcher errorCatcher = new ErrorCatcher();
    public final Mnemonics mnemonics = new Mnemonics();
    public final Parser parser = new Parser(this.mnemonics, this.errorCatcher);

    public Program assemble(String string) {
        this.errorCatcher.clear();
        this.parser.begin(string);
        Program program = this.parser.parseProgram();
        new DefineEQUs(program, this.errorCatcher).visitCommands();
        new EvalEQUs(program, this.errorCatcher, false).visitCommands();
        new ResolveAbsolute(program, this.errorCatcher).visitCommands();
        new ResolveBlocks(program, this.errorCatcher).visitByStructure();
        new EvalEQUs(program, this.errorCatcher, true).visitCommands();
        new ResolveRelative(program, this.errorCatcher).visitCommands();
        new ResolveSymbols(program, this.errorCatcher).visitCommands();
        return program;
    }

    public void generateListing(Program program, Writer writer) {
        new WriteProgram(program, this.errorCatcher, writer).visitCommands();
    }

    public void generateLog(Program program, Writer writer) {
        new WriteSections(program, this.errorCatcher, writer).visitByStructure();
    }

    public void generateObj(Program program, Writer writer, boolean bl) {
        new WriteText(program, this.errorCatcher, writer, bl).visitByStructure();
    }
}

