/*
 * Decompiled with CFR 0.152.
 */
package sic.sim.vm;

import sic.common.Logger;
import sic.common.SICXE;

public class Registers {
    private int PC;
    private int A;
    private int X;
    private int L;
    private int S;
    private int T;
    private int B;
    private double F;
    private int CC;
    public static final int rA = 0;
    public static final int rX = 1;
    public static final int rL = 2;
    public static final int rB = 3;
    public static final int rS = 4;
    public static final int rT = 5;
    public static final int rF = 6;
    public static final int rPC = 8;
    public static final int rSW = 9;

    public int getPC() {
        return this.PC;
    }

    public void setPC(int n) {
        this.PC = SICXE.intToAddr(n);
    }

    public void incPC() {
        if (++this.PC > 1048575) {
            Logger.fmterr("PC register overflow.", new Object[0]);
            this.PC = 0;
        }
    }

    public int getA() {
        return this.A;
    }

    public int getAs() {
        return SICXE.swordToInt(this.A);
    }

    public void setA(int n) {
        this.A = SICXE.intToWord(n);
    }

    public int getALo() {
        return this.A & 0xFF;
    }

    public void setALo(int n) {
        this.A = this.A & 0xFFFF00 | n & 0xFF;
    }

    public int getX() {
        return this.X;
    }

    public int getXs() {
        return SICXE.swordToInt(this.X);
    }

    public void setX(int n) {
        this.X = SICXE.intToWord(n);
    }

    public int getL() {
        return this.L;
    }

    public int getLs() {
        return SICXE.swordToInt(this.L);
    }

    public void setL(int n) {
        this.L = SICXE.intToWord(n);
    }

    public int getS() {
        return this.S;
    }

    public int getSs() {
        return SICXE.swordToInt(this.S);
    }

    public void setS(int n) {
        this.S = SICXE.intToWord(n);
    }

    public int getT() {
        return this.T;
    }

    public int getTs() {
        return SICXE.swordToInt(this.T);
    }

    public void setT(int n) {
        this.T = SICXE.intToWord(n);
    }

    public int getB() {
        return this.B;
    }

    public int getBs() {
        return SICXE.swordToInt(this.B);
    }

    public void setB(int n) {
        this.B = SICXE.intToWord(n);
    }

    public double getF() {
        return this.F;
    }

    public void setF(double d) {
        this.F = d;
    }

    public int getSW() {
        if (this.CC == 0) {
            return 0;
        }
        if (this.CC < 0) {
            return 64;
        }
        return 128;
    }

    public boolean isLower() {
        return this.CC < 0;
    }

    public boolean isEqual() {
        return this.CC == 0;
    }

    public boolean isGreater() {
        return this.CC > 0;
    }

    public void setSW(int n) {
        this.CC = (n & 0x40) == 64 ? -1 : ((n & 0x80) == 128 ? 1 : 0);
    }

    public void setSWAfterCompare(int n) {
        this.CC = n;
    }

    public int get(int n) {
        switch (n) {
            case 0: {
                return this.getA();
            }
            case 1: {
                return this.getX();
            }
            case 2: {
                return this.getL();
            }
            case 3: {
                return this.getB();
            }
            case 4: {
                return this.getS();
            }
            case 5: {
                return this.getT();
            }
            case 6: {
                return (int)this.getF();
            }
            case 8: {
                return this.getPC();
            }
            case 9: {
                return this.getSW();
            }
        }
        Logger.fmterr("Invalid register index '%d'", n);
        return 0;
    }

    public int gets(int n) {
        switch (n) {
            case 0: {
                return this.getAs();
            }
            case 1: {
                return this.getXs();
            }
            case 2: {
                return this.getLs();
            }
            case 3: {
                return this.getBs();
            }
            case 4: {
                return this.getSs();
            }
            case 5: {
                return this.getTs();
            }
            case 6: {
                return (int)this.getF();
            }
            case 8: {
                return this.getPC();
            }
            case 9: {
                return this.getSW();
            }
        }
        Logger.fmterr("Invalid register index '%d'", n);
        return 0;
    }

    public void set(int n, int n2) {
        switch (n) {
            case 0: {
                this.setA(n2);
                break;
            }
            case 1: {
                this.setX(n2);
                break;
            }
            case 2: {
                this.setL(n2);
                break;
            }
            case 3: {
                this.setB(n2);
                break;
            }
            case 4: {
                this.setS(n2);
                break;
            }
            case 5: {
                this.setT(n2);
                break;
            }
            case 6: {
                this.setF(n2);
                break;
            }
            case 8: {
                this.setPC(n2);
                break;
            }
            case 9: {
                this.setSW(n2);
                break;
            }
            default: {
                Logger.fmterr("Invalid register index '%d'", n);
            }
        }
    }

    public void reset() {
        this.PC = 0;
        this.L = 0;
        this.X = 0;
        this.A = 0;
        this.T = 0;
        this.S = 0;
        this.B = 0;
        this.F = 0.0;
        this.CC = 0;
    }

    public Registers() {
        this.reset();
    }
}

