/*
 * Decompiled with CFR 0.152.
 */
package sic.sim.vm;

import java.util.Arrays;
import sic.common.Conversion;
import sic.common.Logger;
import sic.common.SICXE;
import sic.sim.breakpoints.DataBreakpoints;
import sic.sim.breakpoints.ReadDataBreakpointException;
import sic.sim.breakpoints.WriteDataBreakpointException;

public class Memory {
    public final byte[] memory;
    public DataBreakpoints dataBreakpoints = new DataBreakpoints();

    public Memory(int n) {
        this.memory = new byte[n];
    }

    public void reset() {
        Arrays.fill(this.memory, (byte)0);
    }

    private boolean checkAddress(int n) {
        boolean bl;
        boolean bl2 = bl = n < 0 || n >= this.memory.length;
        if (bl) {
            Logger.fmterr("Invalid memory address '%s', %d", Conversion.addrToHex(n), n);
        }
        return bl;
    }

    public int getByte(int n) throws ReadDataBreakpointException {
        if (this.checkAddress(n)) {
            return 0;
        }
        this.dataBreakpoints.checkRead(n);
        return this.memory[n] & 0xFF;
    }

    public void setByte(int n, int n2) throws WriteDataBreakpointException {
        if (this.checkAddress(n)) {
            return;
        }
        this.dataBreakpoints.checkWrite(n);
        this.memory[n] = (byte)(n2 & 0xFF);
    }

    public int getWord(int n) throws ReadDataBreakpointException {
        return this.getByte(n + 2) | this.getByte(n + 1) << 8 | this.getByte(n) << 16;
    }

    public void setWord(int n, int n2) throws WriteDataBreakpointException {
        this.setByte(n, n2 >> 16);
        this.setByte(n + 1, n2 >> 8);
        this.setByte(n + 2, n2);
    }

    public double getFloat(int n) throws ReadDataBreakpointException {
        long l = (long)this.getByte(n) << 40 | (long)this.getByte(n + 1) << 32 | (long)this.getByte(n + 2) << 24 | (long)(this.getByte(n + 3) << 16) | (long)(this.getByte(n + 4) << 8) | (long)this.getByte(n + 5);
        return SICXE.bitsToFloat(l);
    }

    public void setFloat(int n, double d) throws WriteDataBreakpointException {
        long l = SICXE.floatToBits(d);
        this.setByte(n, (int)(l >> 40));
        this.setByte(n + 1, (int)(l >> 32));
        this.setByte(n + 2, (int)(l >> 24));
        this.setByte(n + 3, (int)(l >> 16));
        this.setByte(n + 4, (int)(l >> 8));
        this.setByte(n + 5, (int)l);
    }

    public int getByteRaw(int n) {
        if (this.checkAddress(n)) {
            return 0;
        }
        return this.memory[n] & 0xFF;
    }

    public void setByteRaw(int n, int n2) {
        if (this.checkAddress(n)) {
            return;
        }
        this.memory[n] = (byte)(n2 & 0xFF);
    }

    public int getWordRaw(int n) {
        return this.getByteRaw(n + 2) | this.getByteRaw(n + 1) << 8 | this.getByteRaw(n) << 16;
    }

    public void setWordRaw(int n, int n2) {
        this.setByteRaw(n, n2 >> 16);
        this.setByteRaw(n + 1, n2 >> 8);
        this.setByteRaw(n + 2, n2);
    }

    public double getFloatRaw(int n) {
        long l = (long)this.getByteRaw(n) << 40 | (long)this.getByteRaw(n + 1) << 32 | (long)this.getByteRaw(n + 2) << 24 | (long)(this.getByteRaw(n + 3) << 16) | (long)(this.getByteRaw(n + 4) << 8) | (long)this.getByteRaw(n + 5);
        return SICXE.bitsToFloat(l);
    }

    public void setFloatRaw(int n, double d) {
        long l = SICXE.floatToBits(d);
        this.setByteRaw(n, (int)(l >> 40));
        this.setByteRaw(n + 1, (int)(l >> 32));
        this.setByteRaw(n + 2, (int)(l >> 24));
        this.setByteRaw(n + 3, (int)(l >> 16));
        this.setByteRaw(n + 4, (int)(l >> 8));
        this.setByteRaw(n + 5, (int)l);
    }
}

