/*
 * Decompiled with CFR 0.152.
 */
package sic.sim.views;

import java.util.ArrayList;
import java.util.List;
import sic.ast.StorageSymbol;
import sic.sim.views.SymbolChild;

class SymbolNode {
    private final StorageSymbol symbol;
    private int childrenCount;
    private List<SymbolChild> children = null;

    SymbolNode(StorageSymbol storageSymbol) {
        this.symbol = storageSymbol;
        this.childrenCount = storageSymbol.getElementCount() - 1;
    }

    public StorageSymbol getSymbol() {
        return this.symbol;
    }

    public int getChildrenCount() {
        return this.childrenCount;
    }

    public List<SymbolChild> getChildren() {
        if (this.childrenCount == 0) {
            return null;
        }
        if (this.children == null) {
            ArrayList<SymbolChild> arrayList = new ArrayList<SymbolChild>(this.childrenCount);
            for (int i = 1; i < this.symbol.getElementCount(); ++i) {
                arrayList.add(new SymbolChild(this.symbol, i * this.symbol.getElementSize()));
            }
            this.children = arrayList;
        }
        return this.children;
    }

    public String toString() {
        return this.symbol.toString();
    }
}

