/*
 * Decompiled with CFR 0.152.
 */
package sic.sim.views;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import sic.common.Conversion;
import sic.sim.Colors;
import sic.sim.vm.Machine;
import sic.sim.vm.Memory;
import sic.sim.vm.MemorySpan;

public class HexEdit
extends JPanel
implements FocusListener,
MouseListener,
KeyListener {
    static final int MOVE_MEM_SMALL = 16;
    static final int MOVE_MEM_MEDIUM = 256;
    static final int MOVE_MEM_LARGE = 4096;
    static final int COL_ADDR = 0;
    static final int COL_HEX = 7;
    static final int COL_HEX_LAST = 54;
    static final int COL_CHR = 56;
    static final int COL_CHR_LAST = 71;
    static final int COL_LAST = 72;
    static final int ROW_LAST = 16;
    private Machine machine;
    private Memory memory;
    private int startAddress;
    private int lineHeight;
    private int charWidth;
    private int cursorAddress;
    private boolean focusOnHex;
    private boolean firstNibble;
    ActionListener onAddressChange;

    public HexEdit() {
        this.setForeground(Colors.fg);
        this.setBackground(Colors.bg);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.setFocusTraversalKeysEnabled(false);
        this.focusOnHex = true;
        this.firstNibble = true;
        this.getInputMap().put(KeyStroke.getKeyStroke(37, 0), "left");
        this.getInputMap().put(KeyStroke.getKeyStroke(39, 0), "right");
        this.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "up");
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "down");
        this.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "tab");
        this.getInputMap().put(KeyStroke.getKeyStroke(9, 0), "tab");
        this.getActionMap().put("left", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HexEdit.this.moveCursor(-1, 0);
            }
        });
        this.getActionMap().put("right", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HexEdit.this.moveCursor(1, 0);
            }
        });
        this.getActionMap().put("up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HexEdit.this.moveCursor(0, -1);
            }
        });
        this.getActionMap().put("down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HexEdit.this.moveCursor(0, 1);
            }
        });
        this.getActionMap().put("tab", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HexEdit.this.focusOnHex = !HexEdit.this.focusOnHex;
                HexEdit.this.firstNibble = true;
                HexEdit.this.repaint();
            }
        });
    }

    private int fullRows() {
        return (this.getHeight() - this.getInsets().top - this.getInsets().bottom) / this.lineHeight;
    }

    public int getStartAddress() {
        return this.startAddress;
    }

    public int getEndAddress() {
        return Math.min(this.startAddress + this.fullRows() * 16 - 1, 1048575);
    }

    public void setStartAddress(int n) {
        if (n < 0) {
            return;
        }
        int n2 = n + this.fullRows() * 16 - 1;
        if (n2 > 0x10000E && n > this.startAddress) {
            return;
        }
        int n3 = n - this.startAddress;
        this.startAddress = n;
        this.cursorAddress += n3;
        this.repaint();
        if (this.onAddressChange != null) {
            this.onAddressChange.actionPerformed(null);
        }
    }

    public void moveStartAddress(int n) {
        this.setStartAddress(this.startAddress + n * 16);
    }

    public int getCursorAddress() {
        return this.cursorAddress;
    }

    public void setCursorAddress(int n) {
        if (n < 0 || n > 1048575) {
            return;
        }
        if (n < this.startAddress) {
            this.moveStartAddress(-1);
        }
        if (n > this.getEndAddress()) {
            this.moveStartAddress(1);
        }
        this.cursorAddress = n;
        this.repaint();
        int n2 = this.cursorAddress % 16;
        if (this.cursorAddress > this.getEndAddress()) {
            this.cursorAddress = this.getEndAddress() - 15 + n2;
        }
        if (this.onAddressChange != null) {
            this.onAddressChange.actionPerformed(null);
        }
    }

    public void moveCursor(int n, int n2) {
        this.setCursorAddress(this.cursorAddress + n2 * 16 + n);
    }

    private int maxRows() {
        int n;
        int n2 = this.fullRows();
        return n2 < (n = (1048575 - this.startAddress + 16) / 16) ? n2 : n;
    }

    private int xToCol(int n) {
        int n2 = (n -= this.getInsets().left) / this.charWidth - 56;
        if (0 <= n2 && n2 <= 15) {
            return n2;
        }
        n2 = (n + this.charWidth / 2) / this.charWidth - 7;
        if (n2 < 0) {
            return -1;
        }
        if (0 <= n2 && n2 <= 45) {
            return n2 / 3;
        }
        return -1;
    }

    private int yToRow(int n) {
        if ((n -= this.getInsets().top) < 0) {
            return -1;
        }
        int n2 = n / this.lineHeight;
        if (0 <= n2 && n2 <= this.maxRows()) {
            return n2;
        }
        return -1;
    }

    public void setMachine(Machine machine) {
        this.machine = machine;
        this.memory = machine.memory;
    }

    @Override
    public void setFont(Font font) {
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.lineHeight = fontMetrics.getHeight();
        this.charWidth = fontMetrics.charWidth('0');
        super.setFont(font);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.xToCol(mouseEvent.getX());
        int n2 = this.yToRow(mouseEvent.getY());
        if (n != -1 && n2 != -1) {
            this.setCursorAddress(this.startAddress + n2 * 16 + n);
            this.focusOnHex = (mouseEvent.getX() - this.getInsets().left) / this.charWidth < 56;
            this.firstNibble = true;
            this.repaint();
        }
        if (!this.hasFocus()) {
            this.requestFocus();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    private int get(int n) {
        if (this.memory == null) {
            return 0;
        }
        return this.memory.getByteRaw(n);
    }

    private void set(int n, int n2) {
        if (this.memory != null) {
            this.memory.setByteRaw(n, n2);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\t' || keyEvent.getKeyChar() == '\n') {
            return;
        }
        int n = this.getCursorAddress();
        if (n > 1048575) {
            return;
        }
        if (this.focusOnHex) {
            int n2 = Conversion.hexToInt(String.valueOf(keyEvent.getKeyChar()), -1);
            if (n2 == -1) {
                return;
            }
            int n3 = this.get(n);
            if (n3 < 0) {
                return;
            }
            n3 = this.firstNibble ? n3 & 0xF | (n2 & 0xF) << 4 : n3 & 0xF0 | n2 & 0xF;
            this.set(n, n3);
            boolean bl = this.firstNibble = !this.firstNibble;
            if (this.firstNibble) {
                this.moveCursor(1, 0);
            }
        } else {
            this.set(n, keyEvent.getKeyChar());
            this.moveCursor(1, 0);
        }
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        return new Dimension(72 * this.charWidth + insets.left + insets.right, 16 * this.lineHeight + insets.top + insets.bottom);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = this.startAddress;
        if (n > 1048575) {
            return;
        }
        MemorySpan memorySpan = this.machine.getLastExecRead();
        MemorySpan memorySpan2 = this.machine.getLastExecWrite();
        MemorySpan memorySpan3 = this.machine.getLastExecAddr();
        int n2 = this.getInsets().top + this.lineHeight;
        int n3 = (this.getHeight() - this.getInsets().top - this.getInsets().bottom) / this.lineHeight;
        for (int i = 0; i < n3; ++i) {
            int n4 = this.getInsets().left + 0 * this.charWidth;
            graphics.setColor(Colors.fg);
            graphics.drawString(Conversion.addrToHex(n), n4, n2);
            int n5 = this.getInsets().left + 7 * this.charWidth;
            int n6 = this.getInsets().left + 56 * this.charWidth;
            for (int j = 0; j < 16; ++j) {
                Color color;
                Color color2;
                Color color3;
                Color color4;
                if (n == this.cursorAddress) {
                    color4 = Colors.bg(true, this.focusOnHex && this.isFocusOwner());
                    color3 = Colors.fg(true, this.focusOnHex && this.isFocusOwner());
                    color2 = Colors.bg(true, !this.focusOnHex && this.isFocusOwner());
                    color = Colors.fg(true, !this.focusOnHex && this.isFocusOwner());
                } else if (memorySpan.addressWithinSpan(n)) {
                    color4 = Colors.lastReadBg;
                    color3 = Colors.lastReadFg;
                    color2 = Colors.lastReadBg;
                    color = Colors.lastReadFg;
                } else if (memorySpan2.addressWithinSpan(n)) {
                    color4 = Colors.lastWriteBg;
                    color3 = Colors.lastWriteFg;
                    color2 = Colors.lastWriteBg;
                    color = Colors.lastWriteFg;
                } else if (memorySpan3.addressWithinSpan(n)) {
                    color4 = Colors.currentPcBg;
                    color3 = Colors.currentPcFg;
                    color2 = Colors.currentPcBg;
                    color = Colors.currentPcFg;
                } else {
                    color4 = Colors.bg(false, this.focusOnHex && this.isFocusOwner());
                    color3 = Colors.fg(false, this.focusOnHex && this.isFocusOwner());
                    color2 = Colors.bg(false, !this.focusOnHex && this.isFocusOwner());
                    color = Colors.fg(false, !this.focusOnHex && this.isFocusOwner());
                }
                graphics.setColor(color4);
                graphics.fillRect(n5 - 2, n2 - this.lineHeight + 3, 2 * this.charWidth + 4, this.lineHeight);
                graphics.setColor(color2);
                graphics.fillRect(n6 - 1, n2 - this.lineHeight + 3, this.charWidth + 2, this.lineHeight);
                graphics.setColor(color3);
                int n7 = this.get(n);
                if (n7 < 0) {
                    return;
                }
                char[] cArray = new char[]{'.'};
                if (n7 >= 32 && n7 < 126) {
                    cArray[0] = (char)n7;
                }
                graphics.drawString(Conversion.byteToHex(n7), n5, n2);
                n5 += 3 * this.charWidth;
                graphics.setColor(color);
                graphics.drawChars(cArray, 0, 1, n6, n2);
                n6 += this.charWidth;
                if (++n <= 1048575) continue;
                return;
            }
            n2 += this.lineHeight;
        }
    }
}

