/*
 * Decompiled with CFR 0.152.
 */
package sic.link.utils;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import sic.link.LinkerError;
import sic.link.Options;
import sic.link.section.ERecord;
import sic.link.section.ExtDef;
import sic.link.section.ExtRef;
import sic.link.section.Location;
import sic.link.section.MRecord;
import sic.link.section.Section;
import sic.link.section.TRecord;

public class Parser {
    private static final String PHASE = "parser";
    private String input;
    private int row;
    private Options options;

    public Parser(String string, Options options) {
        this.input = string;
        this.options = options;
    }

    public List<Section> parse() throws LinkerError {
        ArrayList<Section> arrayList = new ArrayList<Section>();
        try {
            Section section = null;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.input));
            char c = (char)bufferedReader.read();
            this.row = 0;
            block14: while (c != '\uffff' && bufferedReader.ready()) {
                switch (c) {
                    case 'H': {
                        long l;
                        String string;
                        if (section != null) {
                            arrayList.add(section);
                        }
                        String string2 = bufferedReader.readLine();
                        ++this.row;
                        if (this.options.isVerbose()) {
                            System.out.println("reading H record: " + string2);
                        }
                        if (string2.length() == 18) {
                            try {
                                string = string2.substring(0, 6).replace(" ", "");
                                l = Long.decode("0x" + string2.substring(6, 12));
                                long l2 = Long.decode("0x" + string2.substring(12, 18));
                                if (l != 0L) {
                                    throw new LinkerError(PHASE, "The section " + string + " is not relative.", new Location(this.input, this.row));
                                }
                                section = new Section(string, l, l2);
                                section.setLocation(new Location(this.input, this.row));
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new LinkerError(PHASE, "Wrong H record format", new Location(this.input, this.row));
                            }
                        } else {
                            throw new LinkerError(PHASE, "H record has incorrect length", new Location(this.input, this.row));
                        }
                        c = (char)bufferedReader.read();
                        continue block14;
                    }
                    case 'E': {
                        if (section == null) {
                            throw new LinkerError(PHASE, "Missing H record", new Location(this.input, this.row));
                        }
                        String string = bufferedReader.readLine();
                        ++this.row;
                        if (this.options.isVerbose()) {
                            System.out.println("reading E record: " + string);
                        }
                        long l = Long.decode("0x" + string);
                        ERecord eRecord = new ERecord(l);
                        eRecord.setLocation(new Location(this.input, this.row));
                        section.setERecord(eRecord);
                        arrayList.add(section);
                        section = null;
                        c = (char)bufferedReader.read();
                        continue block14;
                    }
                    case 'T': {
                        if (section == null && section == null) {
                            throw new LinkerError(PHASE, "Missing H record", new Location(this.input, this.row));
                        }
                        String string = bufferedReader.readLine();
                        ++this.row;
                        if (this.options.isVerbose()) {
                            System.out.println("reading T record: " + string);
                        }
                        long l = Long.decode("0x" + string.substring(0, 6));
                        long l3 = Long.decode("0x" + string.substring(6, 8));
                        String string3 = string.substring(8);
                        TRecord tRecord = new TRecord(l, l3, string3);
                        tRecord.setLocation(new Location(this.input, this.row));
                        section.addTRecord(new TRecord(l, l3, string3));
                        c = (char)bufferedReader.read();
                        continue block14;
                    }
                    case 'M': {
                        if (section == null) {
                            throw new LinkerError(PHASE, "Missing H record", new Location(this.input, this.row));
                        }
                        String string = bufferedReader.readLine();
                        ++this.row;
                        if (this.options.isVerbose()) {
                            System.out.println("reading M record: " + string);
                        }
                        long l = Long.decode("0x" + string.substring(0, 6));
                        long l4 = Long.decode("0x" + string.substring(6, 8));
                        boolean bl = true;
                        String string4 = null;
                        if (string.length() > 8) {
                            bl = string.charAt(8) == '+';
                            string4 = string.substring(9).replace(" ", "");
                        } else {
                            bl = true;
                            string4 = section.getName();
                        }
                        MRecord mRecord = new MRecord(l, (int)l4, bl, string4);
                        mRecord.setLocation(new Location(this.input, this.row));
                        section.addMRecord(mRecord);
                        c = (char)bufferedReader.read();
                        continue block14;
                    }
                    case 'R': {
                        Object object;
                        if (section == null) {
                            throw new LinkerError(PHASE, "Missing H record", new Location(this.input, this.row));
                        }
                        String string = bufferedReader.readLine();
                        ++this.row;
                        if (this.options.isVerbose()) {
                            System.out.println("reading R record: " + string);
                        }
                        for (int i = 0; i < string.length(); i += 6) {
                            String string5 = string.substring(i, i + 6).replace(" ", "");
                            object = new ExtRef(string5);
                            ((ExtRef)object).setLocation(new Location(this.input, this.row));
                            section.addExtRef((ExtRef)object);
                        }
                        c = (char)bufferedReader.read();
                        continue block14;
                    }
                    case 'D': {
                        Object object;
                        if (section == null) {
                            throw new LinkerError(PHASE, "Missing H record", new Location(this.input, this.row));
                        }
                        String string = bufferedReader.readLine();
                        ++this.row;
                        if (this.options.isVerbose()) {
                            System.out.println("reading D record: " + string);
                        }
                        for (int i = 0; i < string.length() - 1; i += 12) {
                            if (string.charAt(i) == ' ') {
                                ++i;
                            }
                            object = string.substring(i, i + 6).replace(" ", "");
                            object = ((String)object).replace(" ", "");
                            long l = Long.decode("0x" + string.substring(i + 6, i + 12));
                            ExtDef extDef = new ExtDef((String)object, l);
                            extDef.setLocation(new Location(this.input, this.row));
                            section.addExtDef(extDef);
                        }
                        c = (char)bufferedReader.read();
                        continue block14;
                    }
                    case '\n': {
                        c = (char)bufferedReader.read();
                        ++this.row;
                        continue block14;
                    }
                }
                throw new LinkerError(PHASE, "Unexpected character '" + c + "' while reading object file", new Location(this.input, this.row));
            }
            if (section != null) {
                arrayList.add(section);
            }
            return arrayList;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new LinkerError(PHASE, "File not found" + this.input);
        }
        catch (IOException iOException) {
            throw new LinkerError(PHASE, "IO exception while reading the file " + this.input + ".");
        }
    }
}

