/*
 * Decompiled with CFR 0.152.
 */
package sic.sim;

import sic.common.Utils;
import sic.sim.AbstractCmdLineArgs;

public class Args
extends AbstractCmdLineArgs {
    private boolean help;
    private String filename;
    private String filebase;
    private String fileext;
    private int freq;
    private int debug;
    private boolean start;
    private boolean stats;
    private boolean textScr;
    private int textScrCols;
    private int textScrRows;
    private boolean graphScr;
    private int graphScrCols;
    private int graphScrRows;
    private int graphScrFreq;
    private boolean keyb;
    private int keybAddress;

    public boolean isHelp() {
        return this.help;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getFilebase() {
        return this.filebase;
    }

    public String getFileext() {
        return this.fileext;
    }

    public boolean hasFilename() {
        return this.filename != null;
    }

    public int getFreq() {
        return this.freq;
    }

    public int getDebug() {
        return this.debug;
    }

    public boolean isStart() {
        return this.start;
    }

    public boolean isStats() {
        return this.stats;
    }

    public boolean isTextScr() {
        return this.textScr;
    }

    public int getTextScrCols() {
        return this.textScrCols;
    }

    public int getTextScrRows() {
        return this.textScrRows;
    }

    public boolean isGraphScr() {
        return this.graphScr;
    }

    public int getGraphScrCols() {
        return this.graphScrCols;
    }

    public int getGraphScrRows() {
        return this.graphScrRows;
    }

    public boolean isKeyb() {
        return this.keyb;
    }

    public int getKeybAddress() {
        return this.keybAddress;
    }

    public int getGraphScrFreq() {
        return this.graphScrFreq;
    }

    public static void printArgs() {
        System.out.print("    -help|-h              Print help.\n    -freq hz              Set the machine frequency.\n    -start                Start on load.\n    -stats                Print instruction statistics.\n    -text colsxrows       Show and resize textual screen.\n    -graph colsxrows[@hz] Show and resize graphical screen.\n    -keyb address         Show and set keyboard address.\n");
    }

    int parseFreq(String string) {
        return Integer.parseInt(string);
    }

    void parseTextScreen(String string) {
        int n = string.indexOf(120);
        this.textScrCols = Integer.parseInt(string.substring(0, n));
        this.textScrRows = Integer.parseInt(string.substring(n + 1));
    }

    void parseGraphScreen(String string) {
        String string2;
        String string3;
        int n = string.indexOf(120);
        int n2 = string.indexOf(64);
        String string4 = string.substring(0, n);
        if (n2 != -1) {
            string3 = string.substring(n + 1, n2);
            string2 = string.substring(n2 + 1);
        } else {
            string3 = string.substring(n + 1);
            string2 = "120";
        }
        this.graphScrCols = Integer.parseInt(string4);
        this.graphScrRows = Integer.parseInt(string3);
        this.graphScrFreq = Integer.parseInt(string2);
    }

    void parseKeyb(String string) {
        this.keybAddress = 49152;
        this.keybAddress = string.startsWith("0x") ? Integer.parseInt(string.substring(2), 16) : Integer.parseInt(string, 10);
    }

    void processArgs(String[] stringArray) {
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            String string;
            switch (string = stringArray[n]) {
                case "-help": 
                case "-h": {
                    this.help = true;
                    break;
                }
                case "-stats": {
                    this.stats = true;
                    break;
                }
                case "-start": {
                    this.start = true;
                    break;
                }
                case "-freq": {
                    this.freq = this.parseFreq(stringArray[++n]);
                    break;
                }
                case "-debug": {
                    this.debug = Integer.parseInt(stringArray[++n]);
                    break;
                }
                case "-text": {
                    this.textScr = true;
                    this.parseTextScreen(stringArray[++n]);
                    break;
                }
                case "-graph": {
                    this.graphScr = true;
                    this.parseGraphScreen(stringArray[++n]);
                    break;
                }
                case "-keyb": {
                    this.keyb = true;
                    this.parseKeyb(stringArray[++n]);
                }
            }
            if (!string.startsWith("-") || string.equals("--")) break;
        }
        if (n < stringArray.length) {
            this.filename = stringArray[n++];
            this.filebase = Utils.getFileBasename(this.filename);
            this.fileext = Utils.getFileExtension(this.filename);
        }
    }

    public Args(String[] stringArray) {
        this.processArgs(stringArray);
    }
}

