/*
 * Decompiled with CFR 0.152.
 */
package sic.common;

public class Opcode {
    public static final int LDA = 0;
    public static final int LDX = 4;
    public static final int LDL = 8;
    public static final int STA = 12;
    public static final int STX = 16;
    public static final int STL = 20;
    public static final int ADD = 24;
    public static final int SUB = 28;
    public static final int MUL = 32;
    public static final int DIV = 36;
    public static final int COMP = 40;
    public static final int TIX = 44;
    public static final int JEQ = 48;
    public static final int JGT = 52;
    public static final int JLT = 56;
    public static final int J = 60;
    public static final int AND = 64;
    public static final int OR = 68;
    public static final int JSUB = 72;
    public static final int RSUB = 76;
    public static final int LDCH = 80;
    public static final int STCH = 84;
    public static final int ADDF = 88;
    public static final int SUBF = 92;
    public static final int MULF = 96;
    public static final int DIVF = 100;
    public static final int COMPF = 136;
    public static final int LDB = 104;
    public static final int LDS = 108;
    public static final int LDF = 112;
    public static final int LDT = 116;
    public static final int STB = 120;
    public static final int STS = 124;
    public static final int STF = 128;
    public static final int STT = 132;
    public static final int LPS = 208;
    public static final int STI = 212;
    public static final int STSW = 232;
    public static final int RD = 216;
    public static final int WD = 220;
    public static final int TD = 224;
    public static final int SSK = 236;
    public static final int FLOAT = 192;
    public static final int FIX = 196;
    public static final int NORM = 200;
    public static final int SIO = 240;
    public static final int HIO = 244;
    public static final int TIO = 248;
    public static final int ADDR = 144;
    public static final int SUBR = 148;
    public static final int MULR = 152;
    public static final int DIVR = 156;
    public static final int COMPR = 160;
    public static final int SHIFTL = 164;
    public static final int SHIFTR = 168;
    public static final int RMO = 172;
    public static final int SVC = 176;
    public static final int CLEAR = 180;
    public static final int TIXR = 184;
    private static final String[] opcodeToNames = new String[]{"LDA", "LDX", "LDL", "STA", "STX", "STL", "ADD", "SUB", "MUL", "DIV", "COMP", "TIX", "JEQ", "JGT", "JLT", "J", "AND", "OR", "JSUB", "RSUB", "LDCH", "STCH", "ADDF", "SUBF", "MULF", "DIVF", "LDB", "LDS", "LDF", "LDT", "STB", "STS", "STF", "STT", "COMPF", null, "ADDR", "SUBR", "MULR", "DIVR", "COMPR", "SHIFTL", "SHIFTR", "RMO", "SVC", "CLEAR", "TIXR", null, "FLOAT", "FIX", "NORM", null, "LPS", "STI", "RD", "WD", "TD", null, "STSW", "SSK", "SIO", "HIO", "TIO", null};
    public static final int START = 0;
    public static final int END = 1;
    public static final int CSECT = 2;
    public static final int USE = 3;
    public static final int EXTREF = 4;
    public static final int EXTDEF = 5;
    public static final int ORG = 6;
    public static final int LTORG = 7;
    public static final int BASE = 8;
    public static final int NOBASE = 9;
    public static final int EQU = 10;
    public static final int RESB = 0;
    public static final int RESW = 1;
    public static final int RESF = 2;
    public static final int BYTE = 3;
    public static final int WORD = 4;
    public static final int FLOT = 5;

    public static String getName(int n) {
        return opcodeToNames[n >> 2];
    }

    public static boolean isValid(int n) {
        return Opcode.getName(n) != null;
    }
}

