/*
 * Decompiled with CFR 0.152.
 */
package sic.ast.storage;

import sic.asm.Location;
import sic.ast.data.Data;
import sic.ast.directives.Directive;
import sic.common.Mnemonic;

public class StorageData
extends Directive {
    public final Data data;
    public final boolean isLiteral;

    public StorageData(Location location, String string, Mnemonic mnemonic, Data data, boolean bl) {
        super(location, string, mnemonic);
        this.data = data;
        this.isLiteral = bl;
    }

    public StorageData(Location location, String string, Mnemonic mnemonic, Data data) {
        this(location, string, mnemonic, data, false);
    }

    public boolean equals(StorageData storageData) {
        return this.data.equals(storageData.data);
    }

    @Override
    public String nameToString() {
        return (this.isLiteral ? "=" : "") + this.mnemonic.name;
    }

    @Override
    public String operandToString() {
        return this.data.toString();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public void emitRawCode(byte[] byArray, int n) {
        this.data.emit(byArray, n);
    }
}

