/*
 * Decompiled with CFR 0.152.
 */
package sic.ast.expression;

import java.util.Set;
import sic.asm.AsmError;
import sic.asm.Location;
import sic.asm.parsing.ExpressionParser;
import sic.ast.Program;

public abstract class Expr {
    public final String name;
    public final Location loc;
    public final int leftBP;

    public Expr(String string, Location location, int n) {
        this.name = string;
        this.loc = location;
        this.leftBP = n;
    }

    public Expr parse(ExpressionParser expressionParser) throws AsmError {
        throw new AsmError(this.loc, "unexpected token '%s'", this);
    }

    public Expr parseLeft(ExpressionParser expressionParser, Expr expr) throws AsmError {
        throw new AsmError(this.loc, "unexpected token '%s'", this);
    }

    public abstract Set<String> extractSyms();

    public int countSyms() {
        Set<String> set = this.extractSyms();
        return set == null ? 0 : set.size();
    }

    public boolean hasSyms() {
        return this.countSyms() > 0;
    }

    public abstract int countAddSub();

    public abstract boolean canEval(Program var1);

    public abstract int eval(Program var1) throws AsmError;
}

