/*
 * Decompiled with CFR 0.152.
 */
package sic.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import sic.asm.AsmError;
import sic.asm.Location;
import sic.ast.Command;
import sic.ast.Program;
import sic.ast.StorageSymbol;
import sic.ast.Symbol;
import sic.ast.expression.Expr;
import sic.ast.storage.StorageData;
import sic.ast.storage.StorageRes;

public class Symbols {
    private int maxLength = 6;
    private Map<String, Symbol> syms = new HashMap<String, Symbol>();
    private Map<String, Set<Symbol>> influences = new HashMap<String, Set<Symbol>>();

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Symbol> entry : this.syms.entrySet()) {
            stringBuilder.append(entry.getKey());
            stringBuilder.append('=');
            stringBuilder.append(entry.getValue().value());
            stringBuilder.append(',');
        }
        return stringBuilder.toString();
    }

    public int maxLength() {
        return this.maxLength;
    }

    public List<Symbol> asSortedList() {
        ArrayList<Symbol> arrayList = new ArrayList<Symbol>(this.syms.values());
        Collections.sort(arrayList);
        return arrayList;
    }

    public List<Symbol> labels() {
        return this.syms.values().stream().filter(symbol -> symbol.labelType != Symbol.LabelType.NOTLABEL).collect(Collectors.toList());
    }

    public List<StorageSymbol> dataLabels() {
        return this.syms.values().stream().filter(symbol -> symbol instanceof StorageSymbol).map(symbol -> (StorageSymbol)symbol).collect(Collectors.toList());
    }

    public Symbol get(String string) {
        return this.syms.get(string);
    }

    public boolean isDefined(String string) {
        return this.syms.containsKey(string);
    }

    public boolean isEvaluated(String string) {
        return this.isDefined(string) && this.syms.get(string).isEvaluated();
    }

    private void define(Symbol symbol) throws AsmError {
        if (symbol.name == null || "".equals(symbol.name)) {
            return;
        }
        if (this.isDefined(symbol.name)) {
            throw new AsmError(symbol.loc, "Duplicate symbol '%s'", symbol.name);
        }
        if (symbol.name.length() > this.maxLength) {
            this.maxLength = symbol.name.length();
        }
        this.syms.put(symbol.name, symbol);
    }

    public void defineLabel(String string, Location location, int n, Command command) throws AsmError {
        Symbol symbol = command instanceof StorageRes || command instanceof StorageData ? new StorageSymbol(string, location, n, command) : new Symbol(string, location, n, false);
        this.define(symbol);
    }

    public void importSymbol(String string, Location location) throws AsmError {
        this.define(new Symbol(string, location));
    }

    public void defineEQU(String string, Location location, Expr expr) throws AsmError {
        Symbol symbol = new Symbol(string, location, expr);
        this.define(symbol);
        Set<String> set = expr.extractSyms();
        if (set == null) {
            return;
        }
        for (String string2 : set) {
            if (!this.influences.containsKey(string2)) {
                this.influences.put(string2, new HashSet());
            }
            this.influences.get(string2).add(symbol);
        }
    }

    public void exportSymbol(String string, Location location) throws AsmError {
        Symbol symbol = this.syms.get(string);
        if (symbol == null) {
            throw new AsmError(location, "Cannot export undefined symbol '%s'", string);
        }
        symbol.setExported();
    }

    public void notify(Program program, String string) throws AsmError {
        if (this.influences.containsKey(string)) {
            for (Symbol symbol : this.influences.get(string)) {
                if (!symbol.decDependencyCount()) continue;
                this.update(program, symbol.name);
            }
        }
    }

    public void update(Program program, String string) throws AsmError {
        Symbol symbol = this.syms.get(string);
        if (symbol.dependencyCount() != 0 || symbol.isEvaluated()) {
            return;
        }
        symbol.eval(program);
        this.notify(program, string);
    }
}

