/*
 * Decompiled with CFR 0.152.
 */
package sic.asm.parsing;

import sic.asm.AsmError;
import sic.asm.parsing.Input;
import sic.common.Conversion;

public class Lexer
extends Input {
    public boolean isWhitespace() {
        return this.peek() == ' ' || this.peek() == '\t' || this.peek() == '\r';
    }

    public boolean isAlpha() {
        return Character.isLetter(this.peek()) || this.peek() == '_';
    }

    public boolean isAlphanumeric() {
        return Character.isLetterOrDigit(this.peek()) || this.peek() == '_';
    }

    public boolean isNewLine() {
        return this.peek() == '\n';
    }

    public void skipWhitespace() {
        while (this.isWhitespace()) {
            this.advance();
        }
    }

    public String skipLinesAndComments() {
        StringBuilder stringBuilder = new StringBuilder();
        while (this.isWhitespace() || this.isNewLine() || this.peek() == '.') {
            String string = this.readIfComment(true, true);
            if (string != null) {
                stringBuilder.append(string);
                stringBuilder.append('\n');
                continue;
            }
            this.advance();
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
    }

    public void skipAlphanumeric() {
        while (this.isAlphanumeric()) {
            this.advance();
        }
    }

    public String readAlphanumeric() {
        int n = this.pos;
        this.skipAlphanumeric();
        return this.extract(n);
    }

    public String readDigits(int n) {
        int n2 = this.pos;
        while (Character.digit(this.peek(), n) != -1) {
            this.advance();
        }
        return this.extract(n2);
    }

    public String readIfComment(boolean bl, boolean bl2) {
        boolean bl3 = this.advanceIf('.');
        if ((bl || this.col == 1) && !bl3) {
            return null;
        }
        String string = this.readUntil('\n').trim();
        if (bl2 && string.length() == 0) {
            return null;
        }
        return string;
    }

    public String readIfLabel() {
        if (this.col == 1 && this.isAlpha()) {
            return this.readAlphanumeric();
        }
        return null;
    }

    public String readIfMnemonic() {
        int n = this.pos;
        this.advanceIf('+');
        this.skipAlphanumeric();
        if (n == this.pos) {
            return null;
        }
        return this.extract(n);
    }

    public void skipComma() throws AsmError {
        this.skipWhitespace();
        this.advance(',');
        this.skipWhitespace();
    }

    public boolean skipIfComma() {
        this.skipWhitespace();
        boolean bl = this.advanceIf(',');
        this.skipWhitespace();
        return bl;
    }

    public boolean skipIfIndexed() throws AsmError {
        if (this.skipIfComma()) {
            this.advance('X');
            return true;
        }
        return false;
    }

    public int readRegister() throws AsmError {
        char c = this.advance();
        int n = Conversion.nameToReg(c);
        if (n < 0) {
            throw new AsmError(this.loc(), "Invalid register '%c'", Character.valueOf(c));
        }
        return n;
    }

    public String readSymbol() throws AsmError {
        String string = this.readAlphanumeric();
        if (string.length() > 0) {
            return string;
        }
        throw new AsmError(this.loc(), "Symbol expected");
    }

    public String readIfSymbol() {
        return this.readAlphanumeric();
    }

    public int readInt(int n, int n2) throws AsmError {
        int n3;
        int n4 = -1;
        boolean bl = this.advanceIf('-');
        if (this.peek() == '0') {
            switch (this.peek(1)) {
                case 'b': {
                    n4 = 2;
                    break;
                }
                case 'o': {
                    n4 = 8;
                    break;
                }
                case 'x': {
                    n4 = 16;
                }
            }
            if (n4 != -1) {
                this.advance();
                this.advance();
            } else {
                n4 = 10;
            }
        } else if (Character.isDigit(this.peek())) {
            n4 = 10;
        } else {
            throw new AsmError(this.loc(), "Number expected");
        }
        try {
            n3 = Integer.parseInt(this.readDigits(n4), n4);
        }
        catch (NumberFormatException numberFormatException) {
            throw new AsmError(this.loc(), "Invalid number");
        }
        if (Character.isLetterOrDigit(this.peek())) {
            throw new AsmError(this.loc(), "invalid digit '%c'", Character.valueOf(this.peek()));
        }
        if (bl) {
            n3 = -n3;
        }
        if (n3 < n || n3 > n2) {
            throw new AsmError(this.loc(), "Number '%d' out of range [%d..%d]", n3, n, n2);
        }
        return n3;
    }

    public double readFloat() throws AsmError {
        double d;
        boolean bl = this.advanceIf('-');
        try {
            d = Double.parseDouble(this.readDigits(10));
        }
        catch (NumberFormatException numberFormatException) {
            throw new AsmError(this.loc(), "Invalid number");
        }
        if (this.advanceIf('.')) {
            try {
                d += Double.parseDouble("0." + this.readDigits(10));
            }
            catch (NumberFormatException numberFormatException) {
                throw new AsmError(this.loc(), "Invalid number");
            }
        }
        if (Character.isLetterOrDigit(this.peek())) {
            throw new AsmError(this.loc(), "invalid digit '%c'", Character.valueOf(this.peek()));
        }
        if (bl) {
            d = -d;
        }
        double d2 = Math.pow(2.0, 47.0) - 1.0;
        double d3 = -d2;
        double d4 = d2;
        if (d < d3 || d > d4) {
            throw new AsmError(this.loc(), "Number '%d' out of range [%d..%d]", d, d3, d4);
        }
        return d;
    }

    public String readEscapedString(char c) throws AsmError {
        StringBuilder stringBuilder = new StringBuilder();
        char c2 = this.advance();
        while (c2 != c) {
            if (!this.ready() || c2 == '\n') {
                throw new AsmError(this.loc(), "Unterminated byte string");
            }
            if (c2 == '\\') {
                c2 = this.advance();
                switch (c2) {
                    case '\"': 
                    case '\\': {
                        break;
                    }
                    case 'n': {
                        c2 = '\n';
                        break;
                    }
                    case 'r': {
                        c2 = '\r';
                        break;
                    }
                    case 't': {
                        c2 = '\t';
                        break;
                    }
                    case 'b': {
                        c2 = '\b';
                        break;
                    }
                    case 'f': {
                        c2 = '\f';
                        break;
                    }
                    case '0': {
                        c2 = '\u0000';
                        break;
                    }
                    case 'x': {
                        int n = this.pos();
                        this.advance(2);
                        String string = this.extract(n);
                        try {
                            c2 = (char)Integer.parseInt(string, 16);
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new AsmError(this.loc(), "Hexadecimal byte expected");
                        }
                    }
                    default: {
                        throw new AsmError(this.loc(), "Unknown escape sequence '\\%c'", Character.valueOf(c2));
                    }
                }
            }
            stringBuilder.append(c2);
            c2 = this.advance();
        }
        return stringBuilder.toString();
    }
}

