/*
 * Decompiled with CFR 0.152.
 */
package sic.sim.views;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Label;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import sic.common.Conversion;
import sic.sim.Executor;
import sic.sim.breakpoints.DataBreakpoint;
import sic.sim.breakpoints.DataBreakpoints;

public class DataBreakpointView {
    private DataBreakpoints dataBreakpoints;
    private JFrame view;
    private JTable table;
    private DefaultTableModel tableModel;
    private JTextField fromField;
    private JTextField toField;
    private JCheckBox readBox;
    private JCheckBox writeBox;
    private JCheckBox enabledBox;
    private JButton addButton;
    private JButton editButton;
    private JButton removeButton;
    private ArrayList<DataBreakpoint> displayedBreakpoints = new ArrayList();

    public DataBreakpointView(Executor executor) {
        this.dataBreakpoints = executor.machine.memory.dataBreakpoints;
        this.view = this.createView();
    }

    private JFrame createView() {
        Object[] objectArray = new String[]{"From", "To", "Read", "Write", "Enabled"};
        this.table = new JTable(){
            private static final long serialVersionUID = 1L;

            @Override
            public Class<?> getColumnClass(int n) {
                switch (n) {
                    case 0: {
                        return String.class;
                    }
                    case 1: {
                        return String.class;
                    }
                    case 2: {
                        return Boolean.class;
                    }
                    case 3: {
                        return Boolean.class;
                    }
                    case 4: {
                        return Boolean.class;
                    }
                }
                return String.class;
            }
        };
        this.tableModel = (DefaultTableModel)this.table.getModel();
        this.tableModel.setColumnIdentifiers(objectArray);
        this.table.setSelectionMode(0);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new BevelBorder(1));
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.table);
        jPanel.add(new JScrollPane(this.table));
        this.fromField = new JTextField("00100", 6);
        this.toField = new JTextField("00150", 6);
        this.readBox = new JCheckBox("Read");
        this.writeBox = new JCheckBox("Write", true);
        this.enabledBox = new JCheckBox("Enabled", true);
        this.addButton = new JButton("Add");
        this.editButton = new JButton("Edit");
        this.removeButton = new JButton("Remove");
        this.editButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        jPanel2.add(new Label("From"));
        jPanel2.add(this.fromField);
        jPanel2.add(new Label("To"));
        jPanel2.add(this.toField);
        jPanel2.add(this.readBox);
        jPanel2.add(this.writeBox);
        jPanel2.add(this.enabledBox);
        jPanel2.add(this.addButton);
        jPanel2.add(this.editButton);
        jPanel2.add(this.removeButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel, "Center");
        jPanel3.add((Component)jPanel2, "South");
        JFrame jFrame = new JFrame("Data breakpoints");
        jFrame.setResizable(false);
        jFrame.setBounds(620, 370, 700, 500);
        jFrame.setContentPane(jPanel3);
        this.bindControls();
        return jFrame;
    }

    private void bindControls() {
        this.table.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                DataBreakpoint dataBreakpoint;
                if (!this.editButton.isEnabled()) {
                    this.editButton.setEnabled(true);
                    this.removeButton.setEnabled(true);
                }
                if ((dataBreakpoint = this.getSelectedBreakpoint()) == null) {
                    return;
                }
                this.fromField.setText(Conversion.addrToHex(dataBreakpoint.getFrom()));
                this.toField.setText(Conversion.addrToHex(dataBreakpoint.getTo()));
                this.readBox.setSelected(dataBreakpoint.getRead());
                this.writeBox.setSelected(dataBreakpoint.getWrite());
                this.enabledBox.setSelected(dataBreakpoint.isEnabled());
            }
        });
        this.tableModel.addTableModelListener(tableModelEvent -> {
            if (tableModelEvent.getType() == 1 || tableModelEvent.getColumn() < 0) {
                return;
            }
            int n = tableModelEvent.getFirstRow();
            int n2 = tableModelEvent.getColumn();
            String string = this.tableModel.getColumnName(n2);
            DataBreakpoint dataBreakpoint = this.dataBreakpoints.at(n);
            Object object = this.tableModel.getValueAt(n, n2);
            switch (string) {
                case "From": {
                    int n3 = Conversion.hexToInt((String)object);
                    int n4 = dataBreakpoint.getTo();
                    try {
                        dataBreakpoint.setRange(n3, n4);
                    }
                    catch (InvalidParameterException invalidParameterException) {
                        JOptionPane.showMessageDialog(this.view, String.format("Invalid range address - %s is not less than or equal to %s.", Conversion.addrToHex(n3), Conversion.addrToHex(n4)), "Invalid data breakpoint", 0);
                    }
                    break;
                }
                case "To": {
                    int n5 = dataBreakpoint.getFrom();
                    int n6 = Conversion.hexToInt((String)object);
                    try {
                        dataBreakpoint.setRange(n5, n6);
                    }
                    catch (InvalidParameterException invalidParameterException) {
                        JOptionPane.showMessageDialog(this.view, String.format("Invalid range address - %s is not less than or equal to %s.", Conversion.addrToHex(n5), Conversion.addrToHex(n6)), "Invalid data breakpoint", 0);
                    }
                    break;
                }
                case "Read": {
                    dataBreakpoint.setRead((Boolean)object);
                    break;
                }
                case "Write": {
                    dataBreakpoint.setWrite((Boolean)object);
                    break;
                }
                case "Enabled": {
                    dataBreakpoint.setEnabled((Boolean)object);
                }
            }
        });
        this.addButton.addActionListener(actionEvent -> {
            DataBreakpoint dataBreakpoint;
            int n = Conversion.hexToInt(this.fromField.getText().replaceFirst("0x", ""));
            int n2 = Conversion.hexToInt(this.toField.getText().replaceFirst("0x", ""));
            boolean bl = this.readBox.isSelected();
            boolean bl2 = this.writeBox.isSelected();
            boolean bl3 = this.enabledBox.isSelected();
            try {
                dataBreakpoint = new DataBreakpoint(n, n2, bl, bl2, bl3);
            }
            catch (InvalidParameterException invalidParameterException) {
                JOptionPane.showMessageDialog(this.view, String.format("Invalid range address - %s is not less than or equal to %s.", this.fromField.getText(), this.toField.getText()), "Invalid data breakpoint", 0);
                return;
            }
            this.dataBreakpoints.add(dataBreakpoint);
            this.addBreakpoint(dataBreakpoint);
        });
        this.editButton.addActionListener(actionEvent -> {
            int n = Conversion.hexToInt(this.fromField.getText().replaceFirst("0x", ""));
            int n2 = Conversion.hexToInt(this.toField.getText().replaceFirst("0x", ""));
            boolean bl = this.readBox.isSelected();
            boolean bl2 = this.writeBox.isSelected();
            boolean bl3 = this.enabledBox.isSelected();
            DataBreakpoint dataBreakpoint = this.getSelectedBreakpoint();
            if (dataBreakpoint != null) {
                try {
                    dataBreakpoint.setRange(n, n2);
                }
                catch (InvalidParameterException invalidParameterException) {
                    JOptionPane.showMessageDialog(this.view, String.format("Invalid range address - %s is not less than or equal to %s.", this.fromField.getText(), this.toField.getText()), "Invalid data breakpoint", 0);
                    return;
                }
                dataBreakpoint.setRead(bl);
                dataBreakpoint.setWrite(bl2);
                dataBreakpoint.setEnabled(bl3);
                this.editBreakpoint(dataBreakpoint, this.table.getSelectedRow());
            }
        });
        this.removeButton.addActionListener(actionEvent -> {
            int n = this.table.getSelectedRow();
            this.dataBreakpoints.remove(n);
            this.removeBreakpoint(n);
        });
    }

    private DataBreakpoint getSelectedBreakpoint() {
        int n = this.table.getSelectedRow();
        if (n == -1) {
            return null;
        }
        return this.dataBreakpoints.at(n);
    }

    private void addBreakpoint(DataBreakpoint dataBreakpoint) {
        this.displayedBreakpoints.add(dataBreakpoint);
        this.tableModel.addRow(dataBreakpoint.toTable());
        this.tableModel.fireTableDataChanged();
    }

    private void editBreakpoint(DataBreakpoint dataBreakpoint, int n) {
        Object[] objectArray = dataBreakpoint.toTable();
        for (int i = 0; i < 5; ++i) {
            this.tableModel.setValueAt(objectArray[i], n, i);
        }
        this.tableModel.fireTableDataChanged();
    }

    private void removeBreakpoint(int n) {
        this.displayedBreakpoints.remove(n);
        this.tableModel.removeRow(n);
        this.tableModel.fireTableDataChanged();
    }

    public void updateView() {
        int n;
        boolean[] blArray = new boolean[this.displayedBreakpoints.size()];
        ArrayList<DataBreakpoint> arrayList = new ArrayList<DataBreakpoint>();
        Iterator<DataBreakpoint> iterator = this.dataBreakpoints.getBreakpointsIterator();
        while (iterator.hasNext()) {
            DataBreakpoint dataBreakpoint = iterator.next();
            n = this.displayedBreakpoints.indexOf(dataBreakpoint);
            if (n == -1) {
                arrayList.add(dataBreakpoint);
                continue;
            }
            blArray[n] = true;
            this.editBreakpoint(dataBreakpoint, n);
        }
        int n2 = 0;
        for (n = 0; n < blArray.length; ++n) {
            if (blArray[n]) continue;
            this.removeBreakpoint(n - n2);
            ++n2;
        }
        for (DataBreakpoint dataBreakpoint : arrayList) {
            this.addBreakpoint(dataBreakpoint);
        }
    }

    public void toggleView() {
        this.view.setVisible(!this.view.isVisible());
    }
}

