/*
 * Decompiled with CFR 0.152.
 */
package sic.link.visitors;

import sic.link.LinkerError;
import sic.link.section.ERecord;
import sic.link.section.ExtDef;
import sic.link.section.ExtRef;
import sic.link.section.MRecord;
import sic.link.section.Section;
import sic.link.section.Sections;
import sic.link.section.TRecord;

public abstract class SectionVisitor {
    public void visit(Sections sections) throws LinkerError {
        for (Section section : sections.getSections()) {
            section.accept(this);
        }
    }

    public void visit(Section section) throws LinkerError {
        if (section.getExtDefs() != null) {
            for (ExtDef object : section.getExtDefs()) {
                object.accept(this);
            }
        }
        if (section.getExtRefs() != null) {
            for (ExtRef extRef : section.getExtRefs()) {
                extRef.accept(this);
            }
        }
        if (section.getTRecords() != null) {
            for (TRecord tRecord : section.getTRecords()) {
                tRecord.accept(this);
            }
        }
        if (section.getMRecords() != null) {
            for (MRecord mRecord : section.getMRecords()) {
                mRecord.accept(this);
            }
        }
    }

    public void visit(ExtDef extDef) throws LinkerError {
    }

    public void visit(ExtRef extRef) throws LinkerError {
    }

    public void visit(TRecord tRecord) throws LinkerError {
    }

    public void visit(MRecord mRecord) throws LinkerError {
    }

    public void visit(ERecord eRecord) throws LinkerError {
    }
}

