/*
 * Decompiled with CFR 0.152.
 */
package sic.common;

import sic.common.SICXE;

public class Conversion {
    public static int hexToInt(String string, int n) {
        try {
            return Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static int hexToInt(String string) {
        return Conversion.hexToInt(string, 0);
    }

    public static String addrToHex(int n) {
        return String.format("%05X", n & 0xFFFFF);
    }

    public static String wordToHex(int n) {
        return String.format("%06X", n & 0xFFFFFF);
    }

    public static String byteToHex(int n) {
        return String.format("%02X", n & 0xFF);
    }

    public static String floatToHex(double d) {
        return String.format("%012X", SICXE.floatToBits(d));
    }

    public static byte[] hexToBytes(String string, int n) {
        assert (string.length() % 2 == 0);
        int n2 = string.length() / 2;
        n2 = (n2 + n - 1) / n * n;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < byArray.length) {
            byArray[n3] = (byte)Integer.parseInt(string.substring(n4, n4 + 2), 16);
            ++n3;
            n4 += 2;
        }
        return byArray;
    }

    public static byte[] hexToBytes(String string) {
        return Conversion.hexToBytes(string, 1);
    }

    public static String bytesToHex(byte[] byArray, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < n + n2 && i < byArray.length; ++i) {
            stringBuilder.append(String.format("%02X", byArray[i]));
        }
        return stringBuilder.toString();
    }

    public static String bytesToHex(byte[] byArray) {
        return Conversion.bytesToHex(byArray, 0, byArray.length);
    }

    public static String bytesToHexNice(byte[] byArray, int n) {
        if (byArray.length > n) {
            return String.format("%02X....%02X", byArray[0], byArray[byArray.length - 1]);
        }
        return String.format("%-8s", Conversion.bytesToHex(byArray, 0, byArray.length));
    }

    public static String hexDump(byte[] byArray, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(String.format("%05X: ", n));
            stringBuilder2.setLength(0);
            for (int j = 0; j <= 15; ++j) {
                int n3 = byArray[n++];
                stringBuilder.append(String.format("%02X ", (byte)n3));
                if (n3 < 32 || n3 > 126) {
                    n3 = 46;
                }
                stringBuilder2.append((char)n3);
            }
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static String byteToBin(int n) {
        Object object = Integer.toBinaryString(n & 0xFF);
        while (((String)object).length() % 8 != 0) {
            object = "0" + (String)object;
        }
        return object;
    }

    public static String dataToByte(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(3 * byArray.length);
        for (int i = 0; i < byArray.length - 1; ++i) {
            stringBuilder.append(Integer.toString(byArray[i] & 0xFF));
            stringBuilder.append(',');
        }
        stringBuilder.append(Integer.toString(byArray[byArray.length - 1] & 0xFF));
        return stringBuilder.toString();
    }

    public static String dataToWord(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(3 * byArray.length);
        for (int i = 0; i < byArray.length - 2; i += 3) {
            int n = byArray[i] << 16 | byArray[i + 1] << 8 | byArray[i + 2];
            stringBuilder.append(Integer.toString(n));
            if (i >= byArray.length - 3) continue;
            stringBuilder.append(',');
        }
        return stringBuilder.toString();
    }

    public static String dataToFloat(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(3 * byArray.length);
        for (int i = 0; i < byArray.length - 5; i += 6) {
            long l = (long)byArray[i] << 40 | (long)byArray[i + 1] << 32 | (long)byArray[i + 2] << 24 | (long)byArray[i + 3] << 16 | (long)byArray[i + 4] << 8 | (long)byArray[i + 5];
            stringBuilder.append(SICXE.bitsToFloat(l));
            if (i >= byArray.length - 6) continue;
            stringBuilder.append(',');
        }
        return stringBuilder.toString();
    }

    public static String regToName(int n) {
        String[] stringArray = new String[]{"A", "X", "L", "B", "S", "T", "F"};
        try {
            return stringArray[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "?";
        }
    }

    public static int nameToReg(char c) {
        return "AXLBSTF".indexOf(c);
    }

    public static String bytesToStr(byte[] byArray, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < n + n2 && i < byArray.length; ++i) {
            stringBuilder.append(String.format("%02X", byArray[i]));
        }
        return stringBuilder.toString();
    }
}

