/*
 * Decompiled with CFR 0.152.
 */
package sic.ast.storage;

import java.util.Arrays;
import sic.asm.AsmError;
import sic.asm.Location;
import sic.ast.Program;
import sic.ast.expression.Expr;
import sic.ast.storage.Storage;
import sic.common.Mnemonic;

public class StorageRes
extends Storage {
    public final Expr expr;
    private int count;

    public StorageRes(Location location, String string, Mnemonic mnemonic, Expr expr) {
        super(location, string, mnemonic);
        this.expr = expr;
    }

    @Override
    public String operandToString() {
        return this.expr.toString();
    }

    @Override
    public int size() {
        switch (this.mnemonic.opcode) {
            case 0: {
                return this.count;
            }
            case 1: {
                return 3 * this.count;
            }
            case 2: {
                return 6 * this.count;
            }
        }
        return 0;
    }

    public void resolve(Program program) throws AsmError {
        this.count = this.expr.eval(program);
    }

    @Override
    public void emitRawCode(byte[] byArray, int n) {
        int n2 = this.size();
        if (n2 <= 0) {
            return;
        }
        Arrays.fill(byArray, n, n + this.size() - 1, (byte)0);
    }

    @Override
    public boolean emitText(StringBuilder stringBuilder) {
        return true;
    }
}

