/*
 * Decompiled with CFR 0.152.
 */
package sic.asm.visitors;

import sic.asm.AsmError;
import sic.asm.ErrorCatcher;
import sic.asm.visitors.Visitor;
import sic.ast.Block;
import sic.ast.Command;
import sic.ast.Program;
import sic.ast.Section;
import sic.ast.directives.DirectiveEQU;
import sic.ast.directives.DirectiveORG;

public class ResolveBlocks
extends Visitor {
    public ResolveBlocks(Program program, ErrorCatcher errorCatcher) {
        super(program, errorCatcher);
    }

    public void visit(Program program) {
        this.visitSections(program.sections);
    }

    public void visit(Section section) {
        int n = this.program.section().isDefault() ? this.program.start() : 0;
        int n2 = 0;
        for (Block block : section.blocks) {
            block.setStart(n);
            try {
                block.enter(this.program);
                this.visit(block);
                block.leave(this.program);
            }
            catch (AsmError asmError) {
                this.errorCatcher.add(asmError);
            }
            n += block.size();
            n2 += block.size();
        }
        section.setSize(n2);
    }

    public void visit(Block block) {
        this.visitCommands(block.commands);
    }

    public void visit(Command command) throws AsmError {
        this.program.section().symbols.defineLabel(command.label(), command.loc, this.program.locctr(), command);
    }

    public void visit(DirectiveEQU directiveEQU) {
    }

    public void visit(DirectiveORG directiveORG) throws AsmError {
        directiveORG.resolve(this.program);
    }
}

