/*
 * Decompiled with CFR 0.152.
 */
package sic.sim.breakpoints;

import java.util.ArrayList;
import java.util.Iterator;
import sic.sim.breakpoints.DataBreakpoint;
import sic.sim.breakpoints.ReadDataBreakpointException;
import sic.sim.breakpoints.WriteDataBreakpointException;

public class DataBreakpoints {
    private ArrayList<DataBreakpoint> breakpoints = new ArrayList();
    private boolean enabled = false;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public Iterator<DataBreakpoint> getBreakpointsIterator() {
        return this.breakpoints.iterator();
    }

    public void checkRead(int n) throws ReadDataBreakpointException {
        if (!this.enabled) {
            return;
        }
        for (DataBreakpoint dataBreakpoint : this.breakpoints) {
            if (!dataBreakpoint.checkRead(n)) continue;
            this.disable();
            throw new ReadDataBreakpointException(dataBreakpoint, n);
        }
    }

    public void checkWrite(int n) throws WriteDataBreakpointException {
        if (!this.enabled) {
            return;
        }
        for (DataBreakpoint dataBreakpoint : this.breakpoints) {
            if (!dataBreakpoint.checkWrite(n)) continue;
            this.disable();
            throw new WriteDataBreakpointException(dataBreakpoint, n);
        }
    }

    public void add(DataBreakpoint dataBreakpoint) {
        this.breakpoints.add(dataBreakpoint);
    }

    public void remove(DataBreakpoint dataBreakpoint) {
        this.breakpoints.remove(dataBreakpoint);
    }

    public void remove(int n) {
        this.breakpoints.remove(n);
    }

    public DataBreakpoint at(int n) {
        return this.breakpoints.get(n);
    }
}

