/*
 * Decompiled with CFR 0.152.
 */
package sic.sim.addons;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import sic.common.Conversion;
import sic.common.GUI;
import sic.common.SICXE;
import sic.sim.Executor;
import sic.sim.vm.Memory;

public class Keyboard {
    public final int ADDRESS = 49152;
    private final Memory memory;
    private final JFrame view;
    private int address;
    private JTextArea inputArea;

    public Keyboard(Executor executor) {
        this.memory = executor.getMachine().memory;
        this.view = this.createView();
        this.setScreen(49152);
    }

    public void setSize(int n, int n2) {
        this.setScreen(this.address);
    }

    public void setScreen(int n) {
        this.address = n;
        this.view.pack();
    }

    private JFrame createView() {
        this.inputArea = new JTextArea();
        this.inputArea.setEditable(false);
        this.inputArea.setText("Type while this window is focused");
        this.inputArea.setColumns(50);
        this.inputArea.setRows(3);
        this.inputArea.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                keyEvent.consume();
                int n = Character.toUpperCase(keyEvent.getKeyChar()) & 0xFF;
                Keyboard.this.inputArea.setText(String.format("%c => %c (%d) ", Character.valueOf(keyEvent.getKeyChar()), Character.valueOf((char)n), n));
                Keyboard.this.memory.setByteRaw(Keyboard.this.address, n);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new BevelBorder(1));
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.inputArea);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add(jPanel);
        JFrame jFrame = new JFrame("Keyboard");
        jFrame.setContentPane(jPanel2);
        return jFrame;
    }

    public void toggleView() {
        this.view.setVisible(!this.view.isVisible());
    }

    public JPanel createSettingsPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(4, 2, 0, 0));
        final JTextField jTextField = GUI.createField(jPanel, "Address", Conversion.addrToHex(this.address), 10);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                try {
                    n = SICXE.intToAddr(Conversion.hexToInt(jTextField.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                Keyboard.this.setScreen(n);
            }
        };
        jTextField.addActionListener(actionListener);
        return jPanel;
    }
}

