/*
 * Decompiled with CFR 0.152.
 */
package sic.link.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import sic.link.Linker;
import sic.link.LinkerError;
import sic.link.Options;
import sic.link.section.Section;
import sic.link.section.Sections;
import sic.link.ui.EditSectionGui;
import sic.link.ui.LinkListener;
import sic.link.ui.SectionEditListener;
import sic.link.utils.Writer;

public class LinkerGui {
    private Options options;
    private List<String> inputs;
    private LinkListener listener;
    private JFrame frame;
    private JTextField name;
    private JLabel label;
    private JButton browse;
    private JButton up;
    private JButton down;
    private JButton remove;
    private JCheckBox force;
    private JCheckBox keep;
    private JCheckBox verbose;
    private JCheckBox edit;
    private JCheckBox main;
    private JTextField mainName;
    private JButton add;
    private JButton help;
    private JButton done;
    private JList<String> list;
    private DefaultListModel<String> model;
    private JScrollPane scrollPane;

    public LinkerGui(Options options, List<String> list, LinkListener linkListener) {
        this.options = options;
        this.inputs = list;
        this.listener = linkListener;
    }

    public void gui() {
        this.frame = new JFrame("Select .obj files to link");
        this.frame.setDefaultCloseOperation(2);
        this.model = new DefaultListModel();
        this.list = new JList<String>(this.model);
        this.scrollPane = new JScrollPane(this.list);
        this.name = new JTextField(40);
        this.label = new JLabel("Output file:");
        this.browse = new JButton("Browse...");
        this.add = new JButton("Add .obj");
        this.force = new JCheckBox("Force");
        this.force.setToolTipText("Force linking even if not all external symbols are resolved");
        this.keep = new JCheckBox("Keep");
        this.keep.setToolTipText("Keep external symbol definitions in the output obj");
        this.verbose = new JCheckBox("Verbose");
        this.verbose.setToolTipText("Show debbuging information on standard output");
        this.edit = new JCheckBox("Edit");
        this.verbose.setToolTipText("Edit the sections and symbols before linking");
        this.main = new JCheckBox("Main");
        this.main.setToolTipText("If not specified, first section will be used");
        this.mainName = new JTextField(8);
        this.mainName.setEnabled(false);
        this.mainName.setMaximumSize(new Dimension(this.mainName.getMaximumSize().width, this.mainName.getPreferredSize().height));
        this.mainName.setVisible(false);
        this.help = new JButton("Help");
        this.done = new JButton("Link");
        this.up = new JButton("Up");
        this.up.setEnabled(false);
        this.up.setPreferredSize(new Dimension(this.up.getMaximumSize().width, this.up.getPreferredSize().height));
        this.down = new JButton("Down");
        this.down.setEnabled(false);
        this.down.setPreferredSize(new Dimension(this.down.getMaximumSize().width, this.down.getPreferredSize().height));
        this.remove = new JButton("Remove");
        this.remove.setEnabled(false);
        this.remove.setHorizontalAlignment(0);
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
                jFileChooser.setFileFilter(new FileNameExtensionFilter("Sic object files", "obj"));
                if (jFileChooser.showSaveDialog(LinkerGui.this.frame) == 0) {
                    File file = jFileChooser.getSelectedFile();
                    if (file.exists()) {
                        LinkerGui.showWarning("Output file already exists and will be overwritten!");
                    }
                    LinkerGui.this.name.setText(file.getAbsolutePath());
                }
            }
        });
        this.add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
                jFileChooser.setFileFilter(new FileNameExtensionFilter("Sic object files", "obj"));
                jFileChooser.setMultiSelectionEnabled(true);
                if (jFileChooser.showOpenDialog(LinkerGui.this.frame) == 0) {
                    File[] fileArray;
                    for (File file : fileArray = jFileChooser.getSelectedFiles()) {
                        LinkerGui.this.model.addElement(file.getPath());
                    }
                }
            }
        });
        this.help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LinkerGui.showHelp();
            }
        });
        this.done.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                block8: {
                    Object object;
                    Options options = new Options();
                    if (LinkerGui.this.options != null) {
                        options.copyFrom(LinkerGui.this.options);
                    }
                    if (((String)(object = LinkerGui.this.name.getText())).length() <= 0) {
                        LinkerGui.showError("Output file not specified");
                        return;
                    }
                    if (!((String)object).endsWith(".obj")) {
                        object = (String)object + ".obj";
                    }
                    File file = new File((String)object);
                    options.setOutputName(file.getName());
                    options.setOutputPath(file.getAbsolutePath());
                    options.setForce(LinkerGui.this.force.isSelected());
                    options.setVerbose(LinkerGui.this.verbose.isSelected());
                    options.setEditing(LinkerGui.this.edit.isSelected());
                    options.setKeep(LinkerGui.this.keep.isSelected());
                    if (LinkerGui.this.main.isSelected()) {
                        if (LinkerGui.this.mainName.getText().length() <= 0) {
                            LinkerGui.showError("Main section not specified");
                            return;
                        }
                        options.setMain(LinkerGui.this.mainName.getText());
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (int i = 0; i < LinkerGui.this.model.size(); ++i) {
                        arrayList.add(LinkerGui.this.model.get(i));
                    }
                    try {
                        LinkerGui.this.link(arrayList, options);
                    }
                    catch (LinkerError linkerError) {
                        System.err.println(linkerError.getMessage());
                        if (LinkerGui.this.listener == null) break block8;
                        LinkerGui.this.listener.onLinked(null, linkerError.getMessage());
                    }
                }
            }
        });
        this.up.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = LinkerGui.this.list.getSelectedIndex();
                if (n > 0 && n < LinkerGui.this.model.size()) {
                    String string = LinkerGui.this.model.remove(n);
                    LinkerGui.this.model.add(n - 1, string);
                    LinkerGui.this.list.setSelectedIndex(n - 1);
                }
            }
        });
        this.down.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = LinkerGui.this.list.getSelectedIndex();
                if (n >= 0 && n < LinkerGui.this.model.size() - 1) {
                    String string = LinkerGui.this.model.remove(n);
                    LinkerGui.this.model.add(n + 1, string);
                    LinkerGui.this.list.setSelectedIndex(n + 1);
                }
            }
        });
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = LinkerGui.this.list.getSelectedIndex();
                if (n >= 0 && n < LinkerGui.this.model.size()) {
                    LinkerGui.this.model.remove(n);
                }
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (LinkerGui.this.list.getSelectedIndex() == -1) {
                    LinkerGui.this.up.setEnabled(false);
                    LinkerGui.this.down.setEnabled(false);
                    LinkerGui.this.remove.setEnabled(false);
                } else {
                    LinkerGui.this.up.setEnabled(true);
                    LinkerGui.this.down.setEnabled(true);
                    LinkerGui.this.remove.setEnabled(true);
                }
            }
        });
        if (this.options != null) {
            if (this.options.getOutputPath() != null) {
                this.name.setText(this.options.getOutputPath());
            }
            if (this.options.isForce()) {
                this.force.setSelected(true);
            }
            if (this.options.isKeep()) {
                this.keep.setSelected(true);
            }
            if (this.options.isVerbose()) {
                this.verbose.setSelected(true);
            }
            if (this.options.isEditing()) {
                this.edit.setSelected(true);
            }
            if (this.options.getMain() != null) {
                this.main.setSelected(true);
                this.mainName.setText(this.options.getMain());
                this.mainName.setVisible(true);
                this.mainName.setEnabled(true);
            }
        }
        if (this.inputs != null) {
            for (String object2 : this.inputs) {
                this.model.addElement(object2);
            }
        }
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.label);
        jPanel4.add(this.name);
        jPanel4.add(this.browse);
        jPanel2.add(this.up);
        jPanel2.add(this.down);
        jPanel2.add(this.remove);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel3.add(new JLabel("Options:"));
        jPanel3.add(this.force);
        jPanel3.add(this.keep);
        jPanel3.add(this.verbose);
        jPanel3.add(this.edit);
        jPanel3.add(this.main);
        jPanel3.add(this.mainName);
        this.main.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (LinkerGui.this.main.isSelected()) {
                    LinkerGui.this.mainName.setEnabled(true);
                    LinkerGui.this.mainName.setVisible(true);
                    LinkerGui.this.mainName.getParent().revalidate();
                } else {
                    LinkerGui.this.mainName.setEnabled(false);
                    LinkerGui.this.mainName.setVisible(false);
                    LinkerGui.this.mainName.getParent().revalidate();
                }
            }
        });
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel2.add(new JPanel());
        jPanel2.add(jPanel3);
        jPanel.add(this.add);
        jPanel.add(this.done);
        jPanel.add(this.help);
        this.frame.add((Component)this.scrollPane, "Center");
        this.frame.add((Component)jPanel, "South");
        this.frame.add((Component)jPanel2, "East");
        this.frame.add((Component)jPanel4, "North");
        this.frame.add((Component)new JPanel(), "West");
        this.frame.setSize(960, 480);
        this.frame.setVisible(true);
    }

    private void link(List<String> list, Options options) throws LinkerError {
        final Linker linker = new Linker(list, options);
        if (options.isEditing()) {
            Sections sections = linker.parse();
            EditSectionGui editSectionGui = new EditSectionGui(sections);
            editSectionGui.sectionEdit(new SectionEditListener(){

                @Override
                public void onEdited(Sections sections, String string) {
                    block3: {
                        Section section = null;
                        try {
                            section = linker.passAndCombine(sections);
                            Writer writer = new Writer(section, LinkerGui.this.options);
                            File file = writer.write();
                            if (LinkerGui.this.listener != null) {
                                LinkerGui.this.listener.onLinked(file, "0");
                            }
                            LinkerGui.this.frame.dispose();
                        }
                        catch (LinkerError linkerError) {
                            System.err.println(linkerError.getMessage());
                            if (LinkerGui.this.listener == null) break block3;
                            LinkerGui.this.listener.onLinked(null, linkerError.getMessage());
                        }
                    }
                }
            });
        } else {
            Section section = linker.link();
            Writer writer = new Writer(section, options);
            File file = writer.write();
            if (this.listener != null) {
                this.listener.onLinked(file, "0");
            }
            this.frame.dispose();
        }
    }

    public static void showSuccess(String string) {
        JOptionPane jOptionPane = new JOptionPane("Linking successful, output: " + string, -1);
        JDialog jDialog = jOptionPane.createDialog("Success");
        jDialog.setAlwaysOnTop(true);
        jDialog.setVisible(true);
    }

    public static void showError(String string) {
        JOptionPane jOptionPane = new JOptionPane(string, 0);
        JDialog jDialog = jOptionPane.createDialog("Error");
        jDialog.setAlwaysOnTop(true);
        jDialog.setVisible(true);
    }

    public static void showWarning(String string) {
        JOptionPane jOptionPane = new JOptionPane(string, 2);
        JDialog jDialog = jOptionPane.createDialog("Warning");
        jDialog.setAlwaysOnTop(true);
        jDialog.setVisible(true);
    }

    public static void showHelp() {
        String string = System.lineSeparator();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Linker for SIC/XE Hypothetical computer").append(string).append(string).append("Links the given relative obj files into one, and resolves references between them them using the R and D records.").append(string).append("The resulting file with resolved references can be loaded and executed using the SicTools simulator.").append(string).append(string).append("Usage:").append(string).append("1. Specify the output file using the input field at the top.").append(string).append("2. Add the assembled obj files to the list using the 'Add .obj' button at the bottom.").append(string).append("3. Move them in the desired order using the Up/Down/Remove buttons on the right.").append(string).append("4. Specify any other options by ticking the checkboxes on the bottom right.").append(string).append("5. Start the linking process by pressing the 'Link' button at the bottom.").append(string).append(string).append("Options: ").append(string).append(" - Force : forces linking even if some references were not resolved. The file needs to be linked further.").append(string).append(" - Keep : keeps the external symbol definitions in the obj file.").append(string).append(" - Main : specifies the main/starting section. When this option is selected an input field for the section name will be shown.").append(string).append(" - Interactive : allows the sections and symbols to be edited before linking.").append(string);
        JOptionPane jOptionPane = new JOptionPane(stringBuilder.toString(), -1);
        JDialog jDialog = jOptionPane.createDialog("SIC Linker Help");
        jDialog.setAlwaysOnTop(true);
        jDialog.setVisible(true);
    }
}

