/*
 * Decompiled with CFR 0.152.
 */
package sic.link.section;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import sic.link.LinkerError;
import sic.link.section.ERecord;
import sic.link.section.ExtDef;
import sic.link.section.ExtRef;
import sic.link.section.MRecord;
import sic.link.section.Section;
import sic.link.section.TRecord;

public class Sections {
    private List<Section> sections = new ArrayList<Section>();
    private Map<String, Section> map = new HashMap<String, Section>();
    private String name;

    public void addSection(Section section) throws LinkerError {
        if (this.map.get(section.getName()) != null) {
            throw new LinkerError("sections", "Duplicated section name: " + section.getName(), section.getLocation());
        }
        this.map.put(section.getName(), section);
        this.sections.add(section);
    }

    public void addSections(List<Section> list) throws LinkerError {
        for (Section section : list) {
            this.addSection(section);
        }
    }

    public void rename(String string, String string2) throws LinkerError {
        Section section = this.map.get(string);
        Section section2 = this.map.get(string2);
        if (section == null) {
            throw new LinkerError("rename section", string + " not found");
        }
        if (section2 != null) {
            throw new LinkerError("rename section", string2 + " is already in use");
        }
        section.setName(string2);
        this.map.remove(string);
        this.map.put(string2, section);
    }

    public void renameDef(String string, String string2, String string3) throws LinkerError {
        Section section = this.map.get(string);
        if (section == null) {
            throw new LinkerError("rename definition", "section " + string + " not found");
        }
        ExtDef extDef = null;
        boolean bl = false;
        for (ExtDef extDef2 : section.getExtDefs()) {
            if (extDef2.getName().equals(string2)) {
                extDef = extDef2;
            }
            if (!extDef2.getName().equals(string3)) continue;
            bl = true;
        }
        if (extDef == null) {
            throw new LinkerError("rename definition", string2 + " not found");
        }
        if (bl) {
            throw new LinkerError("rename definition", string3 + " already exists");
        }
        if (extDef != null) {
            extDef.setName(string3);
        }
    }

    public void renameRef(String string, String string2, String string3) throws LinkerError {
        Section section = this.map.get(string);
        if (section == null) {
            throw new LinkerError("rename reference", "section " + string + " not found");
        }
        ExtRef extRef = null;
        boolean bl = false;
        for (ExtRef object : section.getExtRefs()) {
            if (object.getName().equals(string2)) {
                extRef = object;
            }
            if (!object.getName().equals(string3)) continue;
            bl = true;
        }
        if (extRef == null) {
            throw new LinkerError("rename reference", string2 + " not found");
        }
        if (extRef != null) {
            if (bl) {
                section.getExtRefs().remove(extRef);
            } else {
                extRef.setName(string3);
            }
        }
        for (MRecord mRecord : section.getMRecords()) {
            if (mRecord.getSymbol() == null || !mRecord.getSymbol().equals(string2)) continue;
            mRecord.setSymbol(string3);
        }
    }

    public void remove(String string) throws LinkerError {
        Section section = this.map.get(string);
        if (section == null) {
            throw new LinkerError("remove section", string + " not found");
        }
        this.map.remove(string);
        this.sections.remove(section);
    }

    public void removeDef(String string, String string2) throws LinkerError {
        Section section = this.map.get(string);
        if (section == null) {
            throw new LinkerError("remove definition", string + " not found");
        }
        boolean bl = false;
        ListIterator<ExtDef> listIterator = section.getExtDefs().listIterator();
        while (listIterator.hasNext()) {
            ExtDef extDef = listIterator.next();
            if (!extDef.getName().equals(string2)) continue;
            listIterator.remove();
            bl = true;
        }
        if (!bl) {
            throw new LinkerError("remove definition", string2 + " not found");
        }
    }

    public void removeRef(String string, String string2) throws LinkerError {
        Object object;
        Section section = this.map.get(string);
        if (section == null) {
            throw new LinkerError("remove reference", string + " not found");
        }
        boolean bl = false;
        ListIterator<ExtRef> listIterator = section.getExtRefs().listIterator();
        while (listIterator.hasNext()) {
            object = listIterator.next();
            if (!((ExtRef)object).getName().equals(string2)) continue;
            listIterator.remove();
            bl = true;
        }
        object = section.getMRecords().listIterator();
        while (object.hasNext()) {
            MRecord mRecord = (MRecord)object.next();
            if (mRecord.getSymbol() == null || !mRecord.getSymbol().equals(string2)) continue;
            object.remove();
            bl = true;
        }
        if (!bl) {
            throw new LinkerError("remove reference", string2 + " not found");
        }
    }

    public List<Section> getSections() {
        return this.sections;
    }

    public void setSections(List<Section> list) {
        this.sections = list;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Section getSection(String string) {
        return this.map.get(string);
    }

    public void move(String string, int n) throws LinkerError {
        Section section = null;
        for (Section section2 : this.sections) {
            if (!section2.getName().equals(string)) continue;
            section = section2;
            break;
        }
        if (section == null) {
            throw new LinkerError("move section", string + " not found");
        }
        if (n >= this.sections.size() || n < 0) {
            throw new LinkerError("move section", "position " + n + " is out of bounds");
        }
        this.sections.remove(section);
        this.sections.add(n, section);
    }

    public Section combine(boolean bl) {
        if (this.sections == null || this.sections.size() == 0) {
            return null;
        }
        if (this.name == null) {
            this.name = this.sections.get(0).getName();
        }
        long l = this.sections.get(0).getStart();
        ArrayList<TRecord> arrayList = new ArrayList<TRecord>();
        ArrayList<MRecord> arrayList2 = new ArrayList<MRecord>();
        ArrayList<ExtDef> arrayList3 = new ArrayList<ExtDef>();
        ArrayList<ExtRef> arrayList4 = new ArrayList<ExtRef>();
        for (Section section : this.sections) {
            arrayList.addAll(section.getTRecords());
            arrayList2.addAll(section.getMRecords());
            if (bl) {
                arrayList3.addAll(section.getExtDefs());
            }
            arrayList4.addAll(section.getExtRefs());
        }
        Section section = this.sections.get(this.sections.size() - 1);
        long l2 = section.getStart() + section.getLength() - l;
        Section section2 = new Section(this.name, l, l2, arrayList, arrayList2, arrayList4, arrayList3, new ERecord(l));
        return section2;
    }

    public void clean() {
        Iterator<MRecord> iterator;
        HashSet<String> hashSet = new HashSet<String>();
        HashMap hashMap = new HashMap();
        for (Section section : this.sections) {
            block1: for (MRecord mRecord : section.getMRecords()) {
                if (mRecord.getSymbol() == null || mRecord.getSymbol().equals(this.name)) {
                    ArrayList<MRecord> arrayList = (ArrayList<MRecord>)hashMap.get(mRecord.getStart());
                    if (arrayList == null) {
                        arrayList = new ArrayList<MRecord>();
                        arrayList.add(mRecord);
                        hashMap.put(mRecord.getStart(), arrayList);
                        continue;
                    }
                    ListIterator listIterator = arrayList.listIterator();
                    while (listIterator.hasNext()) {
                        MRecord mRecord2 = (MRecord)listIterator.next();
                        if ((!mRecord.isPositive() || mRecord2.isPositive()) && (mRecord.isPositive() || !mRecord2.isPositive())) continue;
                        mRecord.setDelete(true);
                        mRecord2.setDelete(true);
                        listIterator.remove();
                        continue block1;
                    }
                    continue;
                }
                hashSet.add(mRecord.getSymbol());
            }
            if (hashSet.size() == 0) {
                section.setExtRefs(new ArrayList<ExtRef>());
                continue;
            }
            iterator = section.getExtRefs().listIterator();
            while (iterator.hasNext()) {
                ExtRef extRef = (ExtRef)iterator.next();
                if (hashSet.contains(extRef.getName())) continue;
                iterator.remove();
            }
        }
        for (Section section : this.sections) {
            iterator = section.getMRecords().listIterator();
            while (iterator.hasNext()) {
                MRecord mRecord = (MRecord)iterator.next();
                if (mRecord.getSymbol() != null && mRecord.isPositive() && mRecord.getSymbol().equals(this.name)) {
                    mRecord.setSymbol(null);
                }
                if (!mRecord.isDelete()) continue;
                iterator.remove();
            }
        }
    }
}

