/*
 * Decompiled with CFR 0.152.
 */
package sic.common;

public class SICXE {
    public static final int SIZE_MEM = 0x100000;
    public static final int MASK_ADDR = 1048575;
    public static final int MIN_ADDR = 0;
    public static final int MAX_ADDR = 1048575;
    public static final int SIZE_SICMEM = 32768;
    public static final int MASK_SICADDR = Short.MAX_VALUE;
    public static final int MIN_SICADDR = 0;
    public static final int MAX_SICADDR = Short.MAX_VALUE;
    public static final int MASK_WORD = 0xFFFFFF;
    public static final int MIN_WORD = 0;
    public static final int MAX_WORD = 0xFFFFFF;
    public static final int MASK_SWORD = 0x7FFFFF;
    public static final int MIN_SWORD = -8388608;
    public static final int MAX_SWORD = 0x7FFFFF;
    public static final int MASK_DISP = 4095;
    public static final int MIN_DISP = 0;
    public static final int MAX_DISP = 4095;
    public static final int MASK_SDISP = 2047;
    public static final int MIN_SDISP = -2048;
    public static final int MAX_SDISP = 2047;
    public static final int MIN_BYTE = 0;
    public static final int MAX_BYTE = 255;
    public static final int MIN_SBYTE = -128;
    public static final int MAX_SBYTE = 127;
    public static final int DEVICE_COUNT = 256;
    public static final int MIN_DEVICE = 0;
    public static final int MAX_DEVICE = 255;
    public static final int DEVICE_STDIN = 0;
    public static final int DEVICE_STDOUT = 1;
    public static final int DEVICE_STDERR = 2;
    public static final int DEVICE_FREE = 3;

    public static int intToAddr(int n) {
        return n & 0xFFFFF;
    }

    public static int addrToInt(int n) {
        return n;
    }

    public static boolean isAddr(int n) {
        return 0 <= n && n <= 1048575;
    }

    public static int intToSicAddr(int n) {
        return n & Short.MAX_VALUE;
    }

    public static int sicAddrToInt(int n) {
        return n;
    }

    public static boolean isSicAddr(int n) {
        return 0 <= n && n <= Short.MAX_VALUE;
    }

    public static int intToWord(int n) {
        if (n >= 0) {
            return n & 0xFFFFFF;
        }
        return ~(-n - 1) & 0xFFFFFF;
    }

    public static int wordToInt(int n) {
        return n;
    }

    public static boolean isWord(int n) {
        return 0 <= n && n <= 0xFFFFFF;
    }

    public static int intToSword(int n) {
        return SICXE.intToWord(n);
    }

    public static int swordToInt(int n) {
        if (n <= 0x7FFFFF) {
            return n;
        }
        return -(~n & 0x7FFFFF) - 1;
    }

    public static boolean isSword(int n) {
        return -8388608 <= n && n <= 0x7FFFFF;
    }

    public static int intToDisp(int n) {
        if (n >= 0) {
            return n & 0xFFF;
        }
        return 4096 + n;
    }

    public static int dispToInt(int n) {
        return n;
    }

    public static boolean isDisp(int n) {
        return 0 <= n && n <= 4095;
    }

    public static int intToSdisp(int n) {
        return SICXE.intToDisp(n);
    }

    public static int sdispToInt(int n) {
        if (n <= 0x7FFFFF) {
            return n;
        }
        return -(~n & 0x7FFFFF) - 1;
    }

    public static boolean isSdisp(int n) {
        return -2048 <= n && n <= 2047;
    }

    public static boolean isCdisp(int n) {
        return -2048 <= n && n <= 4095;
    }

    public static long floatToBits(double d) {
        return Double.doubleToLongBits(d) >> 16;
    }

    public static double bitsToFloat(long l) {
        return Double.longBitsToDouble(l << 16);
    }

    public static byte[] intToDataByte(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        return byArray;
    }

    public static byte[] intToDataWord(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return byArray;
    }

    public static byte[] doubleToDataFloat(double d) {
        long l = SICXE.floatToBits(d);
        byte[] byArray = new byte[]{(byte)(l >> 40 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l & 0xFFL)};
        return byArray;
    }
}

