/*
 * Decompiled with CFR 0.152.
 */
package sic.ast.data;

import sic.asm.AsmError;
import sic.asm.parsing.Parser;
import sic.ast.data.Data;
import sic.common.SICXE;

public class DataNum
extends Data {
    private int numint;
    private double numfloat;

    public DataNum(int n) {
        super(n);
    }

    @Override
    public String toString() {
        switch (this.opcode) {
            case 3: 
            case 4: {
                return Integer.toString(this.numint) + super.toString();
            }
            case 5: {
                return Double.toString(this.numfloat) + super.toString();
            }
        }
        return "";
    }

    @Override
    public void parse(Parser parser, boolean bl) throws AsmError {
        switch (this.opcode) {
            case 3: {
                this.numint = parser.readInt(-128, 255);
                this.data = SICXE.intToDataByte(this.numint);
                break;
            }
            case 4: {
                this.numint = parser.readInt(-8388608, 0xFFFFFF);
                this.data = SICXE.intToDataWord(this.numint);
                break;
            }
            case 5: {
                this.numfloat = parser.readFloat();
                this.data = SICXE.doubleToDataFloat(this.numfloat);
            }
        }
        if (bl) {
            super.parse(parser, true);
        }
    }
}

