/*
 * Decompiled with CFR 0.152.
 */
package sic.ast;

import sic.asm.AsmError;
import sic.asm.Location;
import sic.ast.Node;
import sic.ast.Program;
import sic.common.Conversion;
import sic.common.Mnemonic;

public abstract class Command
extends Node {
    public final Location loc;
    public final String label;
    public final Mnemonic mnemonic;
    protected String comment;

    public Command(Location location, String string, Mnemonic mnemonic) {
        this.loc = location;
        this.label = string;
        this.mnemonic = mnemonic;
    }

    public String toString() {
        return this.nameToString() + " " + this.operandToString();
    }

    @Override
    public void enter(Program program) throws AsmError {
        program.step(this.size());
    }

    public void append(Program program) throws AsmError {
        this.enter(program);
        program.append(this);
        this.leave(program);
    }

    public boolean hasLabel() {
        return this.label != null;
    }

    public String label() {
        return this.hasLabel() ? this.label : "";
    }

    public Mnemonic mnemonic() {
        return this.mnemonic;
    }

    public boolean hasComment() {
        return this.comment != null;
    }

    public String geComment() {
        return this.comment;
    }

    public void setComment(String string) {
        if (string != null) {
            string = string.trim();
        }
        this.comment = string;
    }

    public String comment() {
        if (this.comment == null || this.comment.length() == 0) {
            return "";
        }
        return (this.comment.startsWith(".") ? "." : ". ") + this.comment;
    }

    public String nameToString() {
        return this.mnemonic.name;
    }

    public abstract String operandToString();

    public abstract int size();

    public abstract void emitRawCode(byte[] var1, int var2);

    public byte[] emitRawCode() {
        byte[] byArray = new byte[this.size()];
        this.emitRawCode(byArray, 0);
        return byArray;
    }

    public boolean emitText(StringBuilder stringBuilder) {
        if (this.size() > 0) {
            stringBuilder.append(Conversion.bytesToHex(this.emitRawCode()));
        }
        return false;
    }

    public String explain() {
        byte[] byArray = new byte[this.size()];
        this.emitRawCode(byArray, 0);
        Object object = "<b>Hex:</b> ";
        Object object2 = "<b>Bin:</b> ";
        for (int i = 0; i < this.size(); ++i) {
            object = (String)object + Conversion.byteToHex(byArray[i]) + " ";
            object2 = (String)object2 + Conversion.byteToBin(byArray[i]) + " ";
            if (i != 0 || this.size() != 4) continue;
            object2 = (String)object2 + "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        }
        String string = "<b>Opcode:</b> " + Conversion.byteToHex(byArray[0] & 0xFC);
        return (String)object + "<br>" + (String)object2 + "<br>" + string;
    }

    public Integer resolveOperandAddress(int n) {
        return null;
    }
}

