/*
 * Decompiled with CFR 0.152.
 */
package sic;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.UIManager;
import sic.common.Mnemonics;
import sic.disasm.Disassembler;
import sic.sim.Args;
import sic.sim.Executor;
import sic.sim.MainView;
import sic.sim.vm.Machine;

public class Sim {
    public static final int Version_Major = 2;
    public static final int Version_Minor = 0;
    public static final int Version_Patch = 1;

    static void printHelp() {
        System.out.print("Sic/XE Simulator 2.0.1\nUsage: java sic.Sim options parameters\nOptions:\n");
        Args.printArgs();
    }

    public static void main(String[] stringArray) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        Args args = new Args(stringArray);
        if (args.isHelp()) {
            Sim.printHelp();
            return;
        }
        Machine machine = new Machine();
        Executor executor = new Executor(machine, args);
        Disassembler disassembler = new Disassembler(new Mnemonics(), machine);
        final MainView mainView = new MainView(executor, disassembler, args);
        if (args.hasFilename()) {
            mainView.load(new File(args.getFilename()));
        }
        mainView.updateView();
        executor.onBreakpoint = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                mainView.updateView();
            }
        };
        if (args.isStart()) {
            executor.start();
        }
    }
}

