/*
 * Decompiled with CFR 0.152.
 */
package sic.link.section;

import java.util.ArrayList;
import java.util.List;
import sic.link.LinkerError;
import sic.link.section.ERecord;
import sic.link.section.ExtDef;
import sic.link.section.ExtRef;
import sic.link.section.Location;
import sic.link.section.MRecord;
import sic.link.section.TRecord;
import sic.link.visitors.SectionVisitor;

public class Section {
    private String name;
    private long start;
    private long length;
    private List<TRecord> tRecords;
    private List<MRecord> mRecords;
    private List<ExtRef> extRefs;
    private List<ExtDef> extDefs;
    private ERecord eRecord;
    private Location location;

    public Section(String string, long l, long l2, List<TRecord> list, List<MRecord> list2, List<ExtRef> list3, List<ExtDef> list4, ERecord eRecord) {
        this.name = string;
        this.start = l;
        this.length = l2;
        this.tRecords = list;
        this.mRecords = list2;
        this.extRefs = list3;
        this.extDefs = list4;
        this.eRecord = eRecord;
    }

    public Section(String string, long l, long l2) {
        this.name = string;
        this.start = l;
        this.length = l2;
        this.tRecords = new ArrayList<TRecord>();
        this.mRecords = new ArrayList<MRecord>();
        this.extRefs = new ArrayList<ExtRef>();
        this.extDefs = new ArrayList<ExtDef>();
        this.eRecord = null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long l) {
        this.start = l;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long l) {
        this.length = l;
    }

    public List<TRecord> getTRecords() {
        return this.tRecords;
    }

    public void setTRecords(List<TRecord> list) {
        this.tRecords = list;
    }

    public void addTRecord(TRecord tRecord) {
        if (this.tRecords == null) {
            this.tRecords = new ArrayList<TRecord>();
        }
        this.tRecords.add(tRecord);
    }

    public List<MRecord> getMRecords() {
        return this.mRecords;
    }

    public void setMRecords(List<MRecord> list) {
        this.mRecords = list;
    }

    public void addMRecord(MRecord mRecord) {
        if (this.mRecords == null) {
            this.mRecords = new ArrayList<MRecord>();
        }
        this.mRecords.add(mRecord);
    }

    public List<ExtRef> getExtRefs() {
        return this.extRefs;
    }

    public void setExtRefs(List<ExtRef> list) {
        this.extRefs = list;
    }

    public List<ExtDef> getExtDefs() {
        return this.extDefs;
    }

    public void addExtDef(ExtDef extDef) {
        if (this.extDefs == null) {
            this.extDefs = new ArrayList<ExtDef>();
        }
        this.extDefs.add(extDef);
    }

    public void setExtDefs(List<ExtDef> list) {
        this.extDefs = list;
    }

    public ERecord getERecord() {
        return this.eRecord;
    }

    public void addExtRef(ExtRef extRef) {
        if (this.extRefs == null) {
            this.extRefs = new ArrayList<ExtRef>();
        }
        this.extRefs.add(extRef);
    }

    public void setERecord(ERecord eRecord) {
        this.eRecord = eRecord;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public String toString() {
        String string = System.lineSeparator();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Section {" + string);
        stringBuilder.append(" name='" + this.name + "', start=" + this.start + ", length=" + this.length + string);
        stringBuilder.append(" T:" + string);
        if (this.tRecords != null) {
            for (TRecord object : this.tRecords) {
                stringBuilder.append("\t" + object.toString() + string);
            }
        } else {
            stringBuilder.append("\t-" + string);
        }
        stringBuilder.append(" D:" + string);
        if (this.extDefs != null && this.extDefs.size() > 0) {
            for (ExtDef extDef : this.extDefs) {
                stringBuilder.append("\t" + extDef.toString() + string);
            }
        } else {
            stringBuilder.append("\t-" + string);
        }
        stringBuilder.append(" R:" + string);
        if (this.extRefs != null && this.extRefs.size() > 0) {
            for (ExtRef extRef : this.extRefs) {
                stringBuilder.append("\t" + extRef.toString() + string);
            }
        } else {
            stringBuilder.append("\t-" + string);
        }
        stringBuilder.append(" M:" + string);
        if (this.mRecords != null && this.mRecords.size() > 0) {
            for (MRecord mRecord : this.mRecords) {
                stringBuilder.append("\t" + mRecord.toString() + string);
            }
        } else {
            stringBuilder.append("\t-" + string);
        }
        if (this.eRecord != null) {
            stringBuilder.append(" E: " + this.eRecord.toString() + string);
        } else {
            stringBuilder.append(" No E record" + string);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public void accept(SectionVisitor sectionVisitor) throws LinkerError {
        sectionVisitor.visit(this);
    }
}

