/*
 * Decompiled with CFR 0.152.
 */
package sic.asm.visitors;

import sic.asm.AsmError;
import sic.asm.ErrorCatcher;
import sic.asm.visitors.Visitor;
import sic.ast.Program;
import sic.ast.directives.DirectiveBASE;
import sic.ast.directives.DirectiveCSECT;
import sic.ast.directives.DirectiveEXTDEF;
import sic.ast.directives.DirectiveEXTREF;
import sic.ast.directives.DirectiveSTART;

public class ResolveRelative
extends Visitor {
    public ResolveRelative(Program program, ErrorCatcher errorCatcher) {
        super(program, errorCatcher);
    }

    public void visit(DirectiveBASE directiveBASE) throws AsmError {
        directiveBASE.resolve(this.program);
    }

    public void visit(DirectiveEXTREF directiveEXTREF) throws AsmError {
        for (String string : directiveEXTREF.names) {
            this.program.section().symbols.importSymbol(string, directiveEXTREF.loc);
        }
    }

    public void visit(DirectiveEXTDEF directiveEXTDEF) throws AsmError {
        for (String string : directiveEXTDEF.names) {
            this.program.section().symbols.exportSymbol(string, directiveEXTDEF.loc);
        }
    }

    public void visit(DirectiveSTART directiveSTART) throws AsmError {
        this.program.section().symbols.exportSymbol(directiveSTART.label(), directiveSTART.loc);
    }

    public void visit(DirectiveCSECT directiveCSECT) throws AsmError {
        this.program.section().symbols.exportSymbol(directiveCSECT.label(), directiveCSECT.loc);
    }
}

