/*
 * Decompiled with CFR 0.152.
 */
package sic.asm.visitors;

import sic.asm.AsmError;
import sic.asm.ErrorCatcher;
import sic.asm.visitors.Visitor;
import sic.ast.Program;
import sic.ast.directives.DirectiveSTART;
import sic.ast.storage.StorageRes;

public class ResolveAbsolute
extends Visitor {
    public ResolveAbsolute(Program program, ErrorCatcher errorCatcher) {
        super(program, errorCatcher);
    }

    public void visit(DirectiveSTART directiveSTART) throws AsmError {
        if (this.program.start() != this.program.locctr()) {
            throw new AsmError(directiveSTART.loc, "START must precede all instructions");
        }
        if (this.program.name() != null) {
            throw new AsmError(directiveSTART.loc, "Multiple STARTs are not allowed");
        }
        if (directiveSTART.label().length() > 6) {
            throw new AsmError(directiveSTART.loc, "Program name too long");
        }
        directiveSTART.resolve(this.program);
        this.program.setName(directiveSTART.label());
        this.program.setStart(directiveSTART.value());
    }

    public void visit(StorageRes storageRes) throws AsmError {
        storageRes.resolve(this.program);
    }
}

